/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.lamp.core;

import com.artillexstudios.axvaults.libs.lamp.annotation.Command;
import com.artillexstudios.axvaults.libs.lamp.annotation.DefaultFor;
import com.artillexstudios.axvaults.libs.lamp.annotation.DistributeOnMethods;
import com.artillexstudios.axvaults.libs.lamp.annotation.Subcommand;
import com.artillexstudios.axvaults.libs.lamp.core.BaseCommandHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

final class AnnotationReader {
    private static final List<Class<? extends Annotation>> COMMAND_ANNOTATIONS = Stream.of(Command.class, Subcommand.class, DefaultFor.class).collect(Collectors.toList());
    private final AnnotatedElement element;
    private Map<Class<? extends Annotation>, Annotation> annotations;

    public static AnnotationReader create(@NotNull BaseCommandHandler handler, @NotNull AnnotatedElement method) {
        return AnnotationReader.createReader(handler, method);
    }

    public <T extends Annotation> T get(@NotNull Class<T> annotationType) {
        return (T)this.annotations.get(annotationType);
    }

    public void add(@NotNull Annotation annotation) {
        this.annotations.putIfAbsent(annotation.annotationType(), annotation);
    }

    void replaceAnnotations(BaseCommandHandler handler) {
        if (handler.annotationReplacers.isEmpty()) {
            return;
        }
        HashMap<Class<? extends Annotation>, Annotation> newAnnotations = new HashMap<Class<? extends Annotation>, Annotation>(this.annotations);
        for (Annotation annotation : this.annotations.values()) {
            List<Annotation> replaced = handler.replaceAnnotation(this.element, annotation);
            if (replaced == null) continue;
            replaced.forEach(a2 -> newAnnotations.put(a2.annotationType(), (Annotation)a2));
        }
        this.annotations = newAnnotations;
    }

    public boolean shouldDismiss() {
        if (!(this.element instanceof Method)) {
            return false;
        }
        if (this.annotations.isEmpty()) {
            return true;
        }
        return COMMAND_ANNOTATIONS.stream().noneMatch(annotation -> this.annotations.containsKey(annotation));
    }

    @NotNull
    private static AnnotationReader createReader(@NotNull BaseCommandHandler handler, @NotNull AnnotatedElement method) {
        Map<Class<? extends Annotation>, Annotation> annotations = AnnotationReader.toMap(method.getAnnotations());
        AnnotationReader reader = new AnnotationReader(method, annotations);
        reader.replaceAnnotations(handler);
        return reader;
    }

    public void distributeAnnotations() {
        if (this.element instanceof Method) {
            for (Class<?> top = ((Method)this.element).getDeclaringClass(); top != null; top = top.getDeclaringClass()) {
                AnnotationReader.toMap(top.getAnnotations()).forEach((type, annotation) -> {
                    if (type.isAnnotationPresent(DistributeOnMethods.class)) {
                        this.annotations.putIfAbsent((Class<? extends Annotation>)type, (Annotation)annotation);
                    }
                });
            }
        }
    }

    public <R, T extends Annotation> R get(@NotNull Class<T> type, Function<T, R> f) {
        return (R)this.get(type, f, () -> null);
    }

    public <R, T extends Annotation> R get(@NotNull Class<T> type, Function<T, R> f, Supplier<R> def) {
        Annotation ann = this.annotations.get(type);
        if (ann != null) {
            return f.apply(ann);
        }
        return def.get();
    }

    @NotNull
    public <T extends Annotation> T get(@NotNull Class<T> type, String err) {
        T ann = this.get(type);
        if (ann == null) {
            throw new IllegalStateException(err);
        }
        return ann;
    }

    public boolean contains(Class<? extends Annotation> annotation) {
        return this.annotations.containsKey(annotation);
    }

    private static Map<Class<? extends Annotation>, Annotation> toMap(Annotation[] annotations) {
        HashMap<Class<? extends Annotation>, Annotation> map = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation annotation : annotations) {
            map.put(annotation.annotationType(), annotation);
        }
        return map;
    }

    public boolean isEmpty() {
        return this.annotations.isEmpty();
    }

    public String toString() {
        return "AnnotationReader(element=" + this.element + ", annotations=" + this.annotations + ")";
    }

    public AnnotationReader(AnnotatedElement element, Map<Class<? extends Annotation>, Annotation> annotations) {
        this.element = element;
        this.annotations = annotations;
    }
}

