/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.gui.components;

import com.artillexstudios.axvaults.libs.gui.components.GuiType;
import com.artillexstudios.axvaults.libs.gui.components.InventoryProvider;
import net.kyori.adventure.text.Component;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;

public interface GuiContainer {
    @NotNull
    public Component title();

    public void title(@NotNull Component var1);

    @NotNull
    public Inventory createInventory(@NotNull InventoryHolder var1);

    @NotNull
    public GuiType guiType();

    public int inventorySize();

    public int rows();

    public static class Typed
    implements GuiContainer {
        private final InventoryProvider.Typed inventoryProvider;
        private final GuiType guiType;
        private Component title;

        public Typed(@NotNull Component title, @NotNull InventoryProvider.Typed inventoryProvider, @NotNull GuiType guiType) {
            this.inventoryProvider = inventoryProvider;
            this.title = title;
            this.guiType = guiType;
        }

        @Override
        @NotNull
        public Component title() {
            return this.title;
        }

        @Override
        public void title(@NotNull Component title) {
            this.title = title;
        }

        @Override
        public int inventorySize() {
            return this.guiType.getLimit();
        }

        @Override
        @NotNull
        public GuiType guiType() {
            return this.guiType;
        }

        @Override
        public int rows() {
            return 1;
        }

        @Override
        @NotNull
        public Inventory createInventory(@NotNull InventoryHolder inventoryHolder) {
            return this.inventoryProvider.getInventory(this.title, inventoryHolder, this.guiType.getInventoryType());
        }
    }

    public static class Chest
    implements GuiContainer {
        private final InventoryProvider.Chest inventoryProvider;
        private int rows;
        private Component title;

        public Chest(@NotNull Component title, @NotNull InventoryProvider.Chest inventoryProvider, int rows) {
            this.inventoryProvider = inventoryProvider;
            this.title = title;
            this.rows = rows;
        }

        @Override
        @NotNull
        public Component title() {
            return this.title;
        }

        @Override
        public void title(@NotNull Component title) {
            this.title = title;
        }

        @Override
        public int inventorySize() {
            return this.rows * 9;
        }

        @Override
        @NotNull
        public GuiType guiType() {
            return GuiType.CHEST;
        }

        @Override
        public int rows() {
            return this.rows;
        }

        public void rows(int rows) {
            this.rows = rows;
        }

        @Override
        @NotNull
        public Inventory createInventory(@NotNull InventoryHolder inventoryHolder) {
            return this.inventoryProvider.getInventory(this.title, inventoryHolder, this.inventorySize());
        }
    }
}

