/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.axapi.libs.yamlassist.types;

import com.artillexstudios.axvaults.libs.axapi.libs.snakeyaml.error.YAMLException;
import com.artillexstudios.axvaults.libs.axapi.libs.yamlassist.SyntaxError;
import java.util.ArrayList;
import java.util.List;

public class UnknownEscape
extends SyntaxError {
    private final char[] validEscapedCharacters = new char[]{'\\', 'b', 'f', 'n', 'r', 't', 'u', '\"'};

    @Override
    public List<String> getSuggestions(YAMLException exception, List<String> fileLines) {
        ArrayList<String> suggestions = new ArrayList<String>();
        for (int i = 1; i <= fileLines.size(); ++i) {
            String line = fileLines.get(i - 1);
            for (int j = 0; j < line.length(); ++j) {
                if (line.charAt(j) != '\\' || this.isValidEscapedCharacter(line.charAt(j + 1))) continue;
                suggestions.add("Remove the \\ from line " + i + " or add another one after it to make the character display properly.");
                ++j;
            }
        }
        return suggestions;
    }

    private boolean isValidEscapedCharacter(char c2) {
        for (char valid : this.validEscapedCharacters) {
            if (c2 != valid) continue;
            return true;
        }
        return false;
    }
}

