/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.utils;

import com.artillexstudios.axvaults.libs.axapi.items.WrappedItemStack;
import com.artillexstudios.axvaults.libs.axapi.items.component.DataComponent;
import com.artillexstudios.axvaults.libs.axapi.items.component.DataComponents;
import com.artillexstudios.axvaults.libs.axapi.items.component.type.CustomModelData;
import com.artillexstudios.axvaults.utils.SimpleRegex;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Material;

public class ItemMatcher {
    private final WrappedItemStack wrapped;
    private final Map<String, Object> map;
    private final PlainTextComponentSerializer plainSerializer = PlainTextComponentSerializer.plainText();
    private int needMatch = 0;

    public ItemMatcher(WrappedItemStack wrapped, Map<String, Object> map) {
        this.wrapped = wrapped;
        this.map = map;
    }

    public boolean isMatching() {
        int matches = 0;
        if (this.material()) {
            ++matches;
        }
        if (this.name()) {
            ++matches;
        }
        if (this.customModelData()) {
            ++matches;
        }
        return matches >= this.needMatch;
    }

    public boolean material() {
        Object val = this.map.getOrDefault("material", this.map.get("type"));
        if (val == null) {
            return false;
        }
        ++this.needMatch;
        DataComponent<Material> material = DataComponents.material();
        if (material == null) {
            return false;
        }
        return SimpleRegex.matches((String)val, this.wrapped.get(material).toString());
    }

    public boolean name() {
        Object val = this.map.get("name");
        if (val == null) {
            return false;
        }
        ++this.needMatch;
        Component customName = this.wrapped.get(DataComponents.customName());
        if (customName == null) {
            return false;
        }
        String plain = this.plainSerializer.serialize(customName);
        return SimpleRegex.matches((String)val, plain);
    }

    public boolean customModelData() {
        Object val = this.map.get("custom-model-data");
        if (!(val instanceof Integer)) {
            return false;
        }
        Integer num = (Integer)val;
        ++this.needMatch;
        CustomModelData cmd = this.wrapped.get(DataComponents.customModelData());
        if (cmd == null || cmd.floats().isEmpty()) {
            return false;
        }
        return num.intValue() == cmd.floats().getFirst().intValue();
    }
}

