/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.schedulers;

import com.artillexstudios.axvaults.AxVaults;
import com.artillexstudios.axvaults.libs.axapi.executor.ExceptionReportingScheduledThreadPool;
import com.artillexstudios.axvaults.libs.axapi.utils.mutable.MutableInteger;
import com.artillexstudios.axvaults.utils.VaultUtils;
import com.artillexstudios.axvaults.vaults.Vault;
import com.artillexstudios.axvaults.vaults.VaultManager;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;

public class AutoSaveScheduler {
    private static ExceptionReportingScheduledThreadPool pool = null;
    private static long lastSave = -1L;
    private static long savedVaults = -1L;

    public static void start() {
        int time = AxVaults.CONFIG.getInt("auto-save-minutes");
        if (pool != null) {
            pool.shutdown();
        }
        pool = new ExceptionReportingScheduledThreadPool(1);
        pool.scheduleAtFixedRate(() -> {
            long saveStart = System.currentTimeMillis();
            MutableInteger saved = new MutableInteger();
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            for (Vault vault : VaultManager.getVaults()) {
                if (vault.hasChanged().get()) {
                    futures.add(VaultUtils.save(vault));
                    saved.increment();
                }
                if (vault.isOpened()) continue;
                vault.hasChanged().set(false);
                if (Bukkit.getPlayer((UUID)vault.getUUID()) != null || System.currentTimeMillis() - vault.getLastOpen() <= (long)(time - 1) * 1000L) continue;
                VaultManager.removeVault(vault);
            }
            CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)).thenRun(() -> {
                lastSave = System.currentTimeMillis() - saveStart;
                savedVaults = saved.get().intValue();
            });
        }, time, time, TimeUnit.MINUTES);
    }

    public static void stop() {
        if (pool == null) {
            return;
        }
        pool.shutdown();
    }

    public static long getLastSaveLength() {
        return lastSave;
    }

    public static long getSavedVaults() {
        return savedVaults;
    }
}

