/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.axapi.nms.v1_21_R7_paper.wrapper;

import com.artillexstudios.axvaults.libs.axapi.nms.v1_21_R7_paper.BlockSetterImpl;
import com.artillexstudios.axvaults.libs.axapi.nms.v1_21_R7_paper.ParallelBlockSetterImpl;
import com.artillexstudios.axvaults.libs.axapi.nms.v1_21_R7_paper.wrapper.ServerPlayerWrapper;
import com.artillexstudios.axvaults.libs.axapi.selection.BlockSetter;
import com.artillexstudios.axvaults.libs.axapi.selection.ParallelBlockSetter;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;

public final class WorldWrapper
implements com.artillexstudios.axvaults.libs.axapi.nms.wrapper.WorldWrapper {
    private World wrapped;
    private ServerLevel level;

    public WorldWrapper(World world) {
        this.wrapped = world;
    }

    public WorldWrapper(ServerLevel level) {
        this.level = level;
    }

    @Override
    public BlockSetter setter() {
        this.update();
        return new BlockSetterImpl(this.level);
    }

    @Override
    public ParallelBlockSetter parallelSetter() {
        this.update();
        return new ParallelBlockSetterImpl(this.level);
    }

    @Override
    public List<com.artillexstudios.axvaults.libs.axapi.nms.wrapper.ServerPlayerWrapper> players() {
        this.update();
        List players = this.level.players();
        ObjectArrayList playerList = new ObjectArrayList(players.size());
        if (players instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)players;
            for (int i = 0; i < players.size(); ++i) {
                ServerPlayer serverPlayer = (ServerPlayer)arrayList.get(i);
                if (serverPlayer == null) continue;
                playerList.add(new ServerPlayerWrapper(serverPlayer));
            }
        } else {
            for (ServerPlayer serverPlayer : players.toArray(new ServerPlayer[0])) {
                playerList.add(new ServerPlayerWrapper(serverPlayer));
            }
        }
        return playerList;
    }

    @Override
    public void update(boolean force) {
        if (this.level == null || force) {
            this.level = ((CraftWorld)this.wrapped).getHandle();
        }
    }

    @Override
    public World wrapped() {
        World wrapped = this.wrapped;
        if (wrapped == null) {
            this.wrapped = wrapped = this.level.getWorld();
        }
        return wrapped;
    }

    public ServerLevel asMinecraft() {
        this.update();
        return this.level;
    }
}

