/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.database.impl;

import com.artillexstudios.axvaults.AxVaults;
import com.artillexstudios.axvaults.database.Database;
import com.artillexstudios.axvaults.libs.axapi.serializers.Serializers;
import com.artillexstudios.axvaults.libs.axapi.utils.StringUtils;
import com.artillexstudios.axvaults.placed.PlacedVaults;
import com.artillexstudios.axvaults.utils.ThreadUtils;
import com.artillexstudios.axvaults.vaults.Vault;
import com.artillexstudios.axvaults.vaults.VaultPlayer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.UUID;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.h2.jdbc.JdbcConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class H2
implements Database {
    private JdbcConnection conn;

    @Override
    public String getType() {
        return "H2";
    }

    @Override
    public void setup() {
        try {
            this.conn = new JdbcConnection("jdbc:h2:./" + String.valueOf(AxVaults.getInstance().getDataFolder()) + "/data;mode=MySQL", new Properties(), null, null, false);
            this.conn.setAutoCommit(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String CREATE_TABLE = "    CREATE TABLE IF NOT EXISTS `axvaults_data`(\n      `id` INT(128) NOT NULL,\n      `uuid` VARCHAR(36) NOT NULL,\n      `storage` LONGBLOB,\n      `icon` VARCHAR(128)\n    );\n";
        try (PreparedStatement stmt = this.conn.prepareStatement(CREATE_TABLE);){
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        String CREATE_TABLE2 = "    CREATE TABLE IF NOT EXISTS `axvaults_blocks` (\n      `location` VARCHAR(255) NOT NULL,\n      `number` INT,\n      PRIMARY KEY (`location`)\n    );\n";
        try (PreparedStatement stmt = this.conn.prepareStatement(CREATE_TABLE2);){
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void saveVault(Vault vault, Object result) {
        block38: {
            Boolean bool;
            if (result instanceof Boolean && (bool = (Boolean)result).booleanValue()) {
                String sql = "DELETE FROM axvaults_data WHERE uuid = ? AND id = ?;";
                try (PreparedStatement stmt = this.conn.prepareStatement(sql);){
                    stmt.setString(1, vault.getUUID().toString());
                    stmt.setInt(2, vault.getId());
                    stmt.executeUpdate();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
                return;
            }
            if (result == null) {
                Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF0000[AxVaults] Failed to save vault #%s of %s!".formatted(vault.getId(), vault.getUUID().toString()), new TagResolver[0]));
                return;
            }
            byte[] bytes = (byte[])result;
            String sql = "SELECT * FROM axvaults_data WHERE uuid = ? AND id = ?;";
            try (PreparedStatement stmt = this.conn.prepareStatement(sql);){
                stmt.setString(1, vault.getUUID().toString());
                stmt.setInt(2, vault.getId());
                try (ResultSet rs = stmt.executeQuery();){
                    if (rs.next()) {
                        sql = "UPDATE axvaults_data SET storage = ?, icon = ? WHERE uuid = ? AND id = ?;";
                        try (PreparedStatement stmt2 = this.conn.prepareStatement(sql);){
                            stmt2.setBytes(1, bytes);
                            stmt2.setString(2, vault.getRealIcon() == null ? null : vault.getRealIcon().name());
                            stmt2.setString(3, vault.getUUID().toString());
                            stmt2.setInt(4, vault.getId());
                            stmt2.executeUpdate();
                            break block38;
                        }
                    }
                    sql = "INSERT INTO axvaults_data(id, uuid, storage, icon) VALUES (?, ?, ?, ?);";
                    try (PreparedStatement stmt2 = this.conn.prepareStatement(sql);){
                        stmt2.setInt(1, vault.getId());
                        stmt2.setString(2, vault.getUUID().toString());
                        stmt2.setBytes(3, bytes);
                        stmt2.setString(4, vault.getRealIcon() == null ? null : vault.getRealIcon().name());
                        stmt2.executeUpdate();
                    }
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void loadVaults(@NotNull VaultPlayer vaultPlayer) {
        String sql = "SELECT * FROM axvaults_data WHERE uuid = ?;";
        try (PreparedStatement stmt = this.conn.prepareStatement("SELECT * FROM axvaults_data WHERE uuid = ?;");){
            stmt.setString(1, vaultPlayer.getUUID().toString());
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    ItemStack[] items;
                    int id = rs.getInt(1);
                    try {
                        items = Serializers.ITEM_ARRAY.deserialize(rs.getBytes(3));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF0000[AxVaults] Failed to load vault #%s of %s!".formatted(id, vaultPlayer.getUUID().toString()), new TagResolver[0]));
                        continue;
                    }
                    Material icon = rs.getString(4) == null ? null : Material.valueOf((String)rs.getString(4));
                    ThreadUtils.runSync(() -> new Vault(vaultPlayer, id, icon, items));
                }
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isVault(@NotNull Location location) {
        String sql = "SELECT * FROM axvaults_blocks WHERE location = ?;";
        try (PreparedStatement stmt = this.conn.prepareStatement("SELECT * FROM axvaults_blocks WHERE location = ?;");){
            stmt.setString(1, Serializers.LOCATION.serialize(location));
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) return false;
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    @Override
    public void setVault(@NotNull Location location, @Nullable Integer num) {
        String sql = "INSERT INTO `axvaults_blocks`(`location`, `number`) VALUES (?, ?)";
        try (PreparedStatement stmt = this.conn.prepareStatement("INSERT INTO `axvaults_blocks`(`location`, `number`) VALUES (?, ?)");){
            stmt.setString(1, Serializers.LOCATION.serialize(location));
            if (num == null) {
                stmt.setString(2, null);
            } else {
                stmt.setInt(2, num);
            }
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        PlacedVaults.addVault(location, num);
    }

    @Override
    public void removeVault(@NotNull Location location) {
        String sql = "DELETE FROM axvaults_blocks WHERE location = ?;";
        try (PreparedStatement stmt = this.conn.prepareStatement("DELETE FROM axvaults_blocks WHERE location = ?;");){
            stmt.setString(1, Serializers.LOCATION.serialize(location));
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void deleteVault(@NotNull UUID uuid, int num) {
        String sql = "DELETE FROM axvaults_data WHERE uuid = ? AND id = ?;";
        try (PreparedStatement stmt = this.conn.prepareStatement("DELETE FROM axvaults_data WHERE uuid = ? AND id = ?;");){
            stmt.setString(1, uuid.toString());
            stmt.setInt(2, num);
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void load() {
        String sql = "SELECT * FROM axvaults_blocks;";
        try (PreparedStatement stmt = this.conn.prepareStatement("SELECT * FROM axvaults_blocks;");
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                String vault = rs.getString(2);
                Integer vaultInt = vault == null ? null : Integer.valueOf(Integer.parseInt(vault));
                PlacedVaults.addVault(Serializers.LOCATION.deserialize(rs.getString(1)), vaultInt);
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void disable() {
        try {
            this.conn.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

