/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.converters;

import com.artillexstudios.axvaults.libs.axapi.config.Config;
import com.artillexstudios.axvaults.libs.axapi.utils.StringUtils;
import com.artillexstudios.axvaults.utils.VaultUtils;
import com.artillexstudios.axvaults.vaults.Vault;
import com.artillexstudios.axvaults.vaults.VaultManager;
import com.artillexstudios.axvaults.vaults.VaultPlayer;
import java.io.File;
import java.lang.reflect.Method;
import java.util.UUID;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;

public class PlayerVaultsXConverter {
    public void run() {
        File path = new File(Bukkit.getWorldContainer(), "plugins/PlayerVaults/newvaults");
        if (path.exists()) {
            int vaults = 0;
            int players = 0;
            for (File file : path.listFiles()) {
                UUID uuid;
                if (!file.getName().endsWith(".yml")) continue;
                Config data = new Config(file);
                try {
                    uuid = UUID.fromString(file.getName().replace(".yml", ""));
                }
                catch (Exception ex) {
                    continue;
                }
                ++players;
                for (String route : data.getBackingDocument().getRoutesAsStrings(false)) {
                    int num = Integer.parseInt(route.replace("vault", ""));
                    VaultPlayer vaultPlayer = VaultManager.getPlayer(Bukkit.getOfflinePlayer((UUID)uuid)).join();
                    Vault vault = new Vault(vaultPlayer, num, null, this.getItems(data.getString(route)));
                    VaultUtils.save(vault);
                    ++vaults;
                }
            }
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxVaults] Finished converting " + vaults + " vaults of " + players + " players!", new TagResolver[0]));
            return;
        }
        Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF0000[AxVaults] Failed converting! Folder not found!", new TagResolver[0]));
    }

    private ItemStack[] getItems(String base64) {
        try {
            Class<?> cl = Class.forName("com.drtshock.playervaults.vaultmanagement.CardboardBoxSerialization");
            Method method = cl.getDeclaredMethod("fromStorage", String.class, String.class);
            method.setAccessible(true);
            return (ItemStack[])method.invoke(null, base64, "AxVaults");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

