/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.utils;

import com.artillexstudios.axvaults.AxVaults;
import com.artillexstudios.axvaults.libs.axapi.serializers.Serializers;
import com.artillexstudios.axvaults.utils.ThreadUtils;
import com.artillexstudios.axvaults.vaults.Vault;
import java.util.concurrent.CompletableFuture;

public class VaultUtils {
    private static boolean asyncItemSerializer;
    private static boolean deleteEmptyVaults;

    public static void reload() {
        asyncItemSerializer = AxVaults.CONFIG.getBoolean("async-item-serializer", false);
        deleteEmptyVaults = AxVaults.CONFIG.getBoolean("delete-empty-vaults", true);
    }

    public static CompletableFuture<Object> serialize(Vault vault) {
        CompletableFuture<Object> cf = new CompletableFuture<Object>();
        Runnable runnable = () -> {
            if (deleteEmptyVaults && vault.getStorage().isEmpty()) {
                cf.complete(true);
                return;
            }
            try {
                cf.complete(Serializers.ITEM_ARRAY.serialize(vault.getStorage().getContents()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                cf.complete(null);
            }
        };
        if (asyncItemSerializer) {
            runnable.run();
        } else {
            ThreadUtils.runSync(runnable);
        }
        return cf;
    }

    public static boolean isAsyncItemSerializer() {
        return asyncItemSerializer;
    }

    public static boolean isDeleteEmptyVaults() {
        return deleteEmptyVaults;
    }
}

