/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.lamp.bukkit.core;

import com.artillexstudios.axvaults.libs.lamp.CommandHandler;
import com.artillexstudios.axvaults.libs.lamp.autocomplete.SuggestionProvider;
import com.artillexstudios.axvaults.libs.lamp.bukkit.BukkitBrigadier;
import com.artillexstudios.axvaults.libs.lamp.bukkit.BukkitCommandActor;
import com.artillexstudios.axvaults.libs.lamp.bukkit.BukkitCommandHandler;
import com.artillexstudios.axvaults.libs.lamp.bukkit.Version;
import com.artillexstudios.axvaults.libs.lamp.bukkit.adventure.AudienceSenderResolver;
import com.artillexstudios.axvaults.libs.lamp.bukkit.adventure.ComponentResponseHandler;
import com.artillexstudios.axvaults.libs.lamp.bukkit.brigadier.CommodoreBukkitBrigadier;
import com.artillexstudios.axvaults.libs.lamp.bukkit.core.BukkitActor;
import com.artillexstudios.axvaults.libs.lamp.bukkit.core.BukkitCommandExecutor;
import com.artillexstudios.axvaults.libs.lamp.bukkit.core.BukkitCommandListeners;
import com.artillexstudios.axvaults.libs.lamp.bukkit.core.BukkitPermissionReader;
import com.artillexstudios.axvaults.libs.lamp.bukkit.core.BukkitSenderResolver;
import com.artillexstudios.axvaults.libs.lamp.bukkit.core.EntitySelectorResolver;
import com.artillexstudios.axvaults.libs.lamp.bukkit.exception.BukkitExceptionAdapter;
import com.artillexstudios.axvaults.libs.lamp.bukkit.exception.InvalidPlayerException;
import com.artillexstudios.axvaults.libs.lamp.bukkit.exception.InvalidWorldException;
import com.artillexstudios.axvaults.libs.lamp.bukkit.exception.MalformedEntitySelectorException;
import com.artillexstudios.axvaults.libs.lamp.bukkit.exception.MoreThanOnePlayerException;
import com.artillexstudios.axvaults.libs.lamp.bukkit.exception.NonPlayerEntitiesException;
import com.artillexstudios.axvaults.libs.lamp.command.CommandActor;
import com.artillexstudios.axvaults.libs.lamp.command.CommandCategory;
import com.artillexstudios.axvaults.libs.lamp.command.ExecutableCommand;
import com.artillexstudios.axvaults.libs.lamp.core.BaseCommandHandler;
import com.artillexstudios.axvaults.libs.lamp.core.CommandPath;
import com.artillexstudios.axvaults.libs.lamp.exception.EnumNotFoundException;
import com.artillexstudios.axvaults.libs.lamp.util.Preconditions;
import com.artillexstudios.axvaults.libs.lamp.util.Primitives;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class BukkitHandler
extends BaseCommandHandler
implements BukkitCommandHandler {
    public static final SuggestionProvider playerSuggestionProvider;
    private final Plugin plugin;
    private Optional<BukkitBrigadier> brigadier;
    @Nullable
    Object bukkitAudiences;
    private static final Constructor<PluginCommand> COMMAND_CONSTRUCTOR;
    @Nullable
    private static final Field KNOWN_COMMANDS;
    private static final CommandMap COMMAND_MAP;

    public BukkitHandler(@NotNull Plugin plugin) {
        this.plugin = Preconditions.notNull(plugin, "plugin");
        try {
            this.brigadier = Optional.of(new CommodoreBukkitBrigadier(this));
        }
        catch (NoClassDefFoundError e) {
            this.brigadier = Optional.empty();
        }
        this.registerSenderResolver(BukkitSenderResolver.INSTANCE);
        this.registerValueResolver(Player.class, context -> {
            String value = context.pop();
            if (value.equalsIgnoreCase("self") || value.equalsIgnoreCase("me")) {
                return ((BukkitCommandActor)context.actor()).requirePlayer();
            }
            if (EntitySelectorResolver.INSTANCE.supportsComplexSelectors()) {
                try {
                    List entityList = Bukkit.selectEntities((CommandSender)((BukkitActor)context.actor()).getSender(), (String)value);
                    if (entityList.stream().anyMatch(c2 -> !(c2 instanceof Player))) {
                        throw new NonPlayerEntitiesException(value);
                    }
                    if (entityList.isEmpty()) {
                        throw new InvalidPlayerException(context.parameter(), value);
                    }
                    if (entityList.size() > 1) {
                        throw new MoreThanOnePlayerException(value);
                    }
                    return (Player)entityList.get(0);
                }
                catch (IllegalArgumentException e) {
                    throw new MalformedEntitySelectorException((CommandActor)context.actor(), value, e.getCause().getMessage());
                }
            }
            Player player = Bukkit.getPlayerExact((String)value);
            if (player == null) {
                throw new InvalidPlayerException(context.parameter(), value);
            }
            return player;
        });
        this.registerValueResolver(OfflinePlayer.class, context -> {
            String value = context.pop();
            if (value.equalsIgnoreCase("self") || value.equalsIgnoreCase("me")) {
                return ((BukkitCommandActor)context.actor()).requirePlayer();
            }
            OfflinePlayer player = BukkitHandler.getCachedOfflinePlayer(value);
            if (player == null && !(player = Bukkit.getOfflinePlayer((String)value)).hasPlayedBefore()) {
                throw new InvalidPlayerException(context.parameter(), value);
            }
            return player;
        });
        this.registerValueResolver(World.class, context -> {
            String value = context.pop();
            if (value.equalsIgnoreCase("self") || value.equalsIgnoreCase("me")) {
                return ((BukkitCommandActor)context.actor()).requirePlayer().getWorld();
            }
            World world = Bukkit.getWorld((String)value);
            if (world == null) {
                throw new InvalidWorldException(context.parameter(), value);
            }
            return world;
        });
        this.registerValueResolver(EntityType.class, context -> {
            EntityType type;
            String value = context.pop().toLowerCase();
            if (value.startsWith("minecraft:")) {
                value = value.substring("minecraft:".length());
            }
            if ((type = EntityType.fromName((String)value)) == null) {
                throw new EnumNotFoundException(context.parameter(), value);
            }
            return type;
        });
        if (EntitySelectorResolver.INSTANCE.supportsComplexSelectors() && this.isBrigadierSupported()) {
            this.getAutoCompleter().registerParameterSuggestions(EntityType.class, SuggestionProvider.EMPTY);
        }
        this.registerValueResolverFactory(EntitySelectorResolver.INSTANCE);
        this.getAutoCompleter().registerSuggestion("players", playerSuggestionProvider);
        this.getAutoCompleter().registerSuggestion("worlds", SuggestionProvider.map(Bukkit::getWorlds, World::getName));
        this.getAutoCompleter().registerParameterSuggestions(Player.class, "players");
        this.getAutoCompleter().registerParameterSuggestions(OfflinePlayer.class, "players");
        this.getAutoCompleter().registerParameterSuggestions(World.class, "worlds");
        this.getAutoCompleter().registerSuggestionFactory(EntitySelectorResolver.SelectorSuggestionFactory.INSTANCE);
        this.registerContextValue(plugin.getClass(), plugin);
        this.registerDependency(plugin.getClass(), plugin);
        this.registerDependency(FileConfiguration.class, () -> ((Plugin)plugin).getConfig());
        this.registerDependency(Logger.class, () -> ((Plugin)plugin).getLogger());
        this.registerPermissionReader(BukkitPermissionReader.INSTANCE);
        this.setExceptionHandler(BukkitExceptionAdapter.INSTANCE);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new BukkitCommandListeners(this), plugin);
    }

    @Override
    @NotNull
    public CommandHandler register(Object ... commands) {
        super.register(commands);
        for (ExecutableCommand command : this.executables.values()) {
            if (command.getParent() != null) continue;
            this.createPluginCommand(command.getName(), command.getDescription(), command.getUsage());
        }
        for (CommandCategory category : this.categories.values()) {
            if (category.getParent() != null) continue;
            this.createPluginCommand(category.getName(), null, null);
        }
        return this;
    }

    @Override
    @NotNull
    public Optional<BukkitBrigadier> getBrigadier() {
        return this.brigadier;
    }

    @Override
    public boolean isBrigadierSupported() {
        return this.brigadier.isPresent();
    }

    @Override
    public BukkitCommandHandler registerBrigadier() {
        this.brigadier.ifPresent(BukkitBrigadier::register);
        return this;
    }

    @Override
    public void enableAdventure() {
        if (Audience.class.isAssignableFrom(CommandSender.class)) {
            this.registerSenderResolver(new AudienceSenderResolver(sender -> (Audience)sender));
            this.registerResponseHandler(ComponentLike.class, new ComponentResponseHandler(sender -> (Audience)sender));
        } else {
            this.enableAdventure(BukkitAudiences.create((Plugin)this.plugin));
        }
    }

    @Override
    public void enableAdventure(@NotNull BukkitAudiences audiences) {
        Preconditions.notNull(audiences, "audiences");
        this.bukkitAudiences = audiences;
        this.registerSenderResolver(new AudienceSenderResolver(arg_0 -> ((BukkitAudiences)audiences).sender(arg_0)));
        this.registerResponseHandler(ComponentLike.class, new ComponentResponseHandler(arg_0 -> ((BukkitAudiences)audiences).sender(arg_0)));
    }

    @Override
    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }

    private void createPluginCommand(String name, @Nullable String description, @Nullable String usage) {
        PluginCommand cmd = ((JavaPlugin)this.plugin).getCommand(name);
        if (cmd == null) {
            cmd = COMMAND_CONSTRUCTOR.newInstance(name, this.plugin);
            COMMAND_MAP.register(this.plugin.getName(), (Command)cmd);
        }
        BukkitCommandExecutor executor = new BukkitCommandExecutor(this);
        cmd.setExecutor((CommandExecutor)executor);
        cmd.setTabCompleter((TabCompleter)executor);
        if (cmd.getDescription().isEmpty() && description != null) {
            cmd.setDescription(description);
        }
        if (cmd.getUsage().isEmpty() && usage != null) {
            cmd.setUsage(usage);
        }
    }

    @Override
    public boolean unregister(@NotNull CommandPath path) {
        if (path.isRoot()) {
            PluginCommand command = ((JavaPlugin)this.plugin).getCommand(path.getFirst());
            this.unregisterCommand(command);
        }
        return super.unregister(path);
    }

    private void unregisterCommand(PluginCommand command) {
        if (command != null) {
            command.unregister(COMMAND_MAP);
            Map<String, Command> knownCommands = BukkitHandler.getKnownCommands();
            if (knownCommands != null) {
                Command rawAlias = knownCommands.get(command.getName());
                if (rawAlias instanceof PluginCommand && ((PluginCommand)rawAlias).getPlugin() == this.plugin) {
                    knownCommands.remove(command.getName());
                }
                knownCommands.remove(this.plugin.getDescription().getName() + ":" + command.getName());
            }
        }
    }

    public static Class<? extends Entity> getSelectedEntity(@NotNull Type selectorType) {
        return (Class)Primitives.getInsideGeneric(selectorType, Entity.class);
    }

    @Nullable
    private static Map<String, Command> getKnownCommands() {
        if (KNOWN_COMMANDS != null) {
            return (Map)KNOWN_COMMANDS.get(COMMAND_MAP);
        }
        return null;
    }

    private static OfflinePlayer getCachedOfflinePlayer(String name) {
        Player offlinePlayer = Bukkit.getPlayerExact((String)name);
        if (offlinePlayer == null) {
            try {
                Object gameProfileCache;
                Class<?> minecraftServerClass = Class.forName("net.minecraft.server.MinecraftServer");
                Method minecraftServer = minecraftServerClass.getDeclaredMethod("getServer", new Class[0]);
                minecraftServer.setAccessible(true);
                Object serverInstance = minecraftServer.invoke(null, new Object[0]);
                switch (Version.getServerVersion()) {
                    case v1_20_1: 
                    case v1_20_2: {
                        Method method = minecraftServerClass.getDeclaredMethod("ap", new Class[0]);
                        method.setAccessible(true);
                        gameProfileCache = method.invoke(serverInstance, new Object[0]);
                        break;
                    }
                    case v1_20_3: {
                        Method method = minecraftServerClass.getDeclaredMethod("ar", new Class[0]);
                        method.setAccessible(true);
                        gameProfileCache = method.invoke(serverInstance, new Object[0]);
                        break;
                    }
                    case v1_20_4: 
                    case v1_21: {
                        Method method = minecraftServerClass.getDeclaredMethod("au", new Class[0]);
                        method.setAccessible(true);
                        gameProfileCache = method.invoke(serverInstance, new Object[0]);
                        break;
                    }
                    case v1_21_2: 
                    case v1_21_3: 
                    case v1_21_4: 
                    case v1_21_5: 
                    case v1_21_6: {
                        Method method = minecraftServerClass.getDeclaredMethod("at", new Class[0]);
                        method.setAccessible(true);
                        gameProfileCache = method.invoke(serverInstance, new Object[0]);
                    }
                    default: {
                        Method servicesMethod = minecraftServerClass.getDeclaredMethod("av", new Class[0]);
                        servicesMethod.setAccessible(true);
                        Object services = servicesMethod.invoke(null, new Object[0]);
                        Class<?> servicesClass = Class.forName("net.minecraft.server.Services");
                        Method nameToIdCacheGetterMethod = servicesClass.getDeclaredMethod("f", new Class[0]);
                        gameProfileCache = nameToIdCacheGetterMethod.invoke(services, new Object[0]);
                        break;
                    }
                }
                if (gameProfileCache == null) {
                    return null;
                }
                if (Version.getServerVersion().isOlderThan(Version.v1_21_7)) {
                    Object gameProfile = gameProfileCache.getClass().getDeclaredMethod("getProfileIfCached", String.class).invoke(gameProfileCache, name);
                    if (gameProfile != null) {
                        return (OfflinePlayer)Bukkit.getServer().getClass().getDeclaredMethod("getOfflinePlayer", Class.forName("com.mojang.authlib.GameProfile")).invoke((Object)Bukkit.getServer(), gameProfile);
                    }
                } else {
                    Object nameAndId = gameProfileCache.getClass().getDeclaredMethod("getIfCached", String.class).invoke(gameProfileCache, name);
                    if (nameAndId != null) {
                        return (OfflinePlayer)Bukkit.getServer().getClass().getDeclaredMethod("getOfflinePlayer", Class.forName("net.minecraft.server.players.NameAndId")).invoke((Object)Bukkit.getServer(), nameAndId);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return offlinePlayer;
    }

    static {
        CommandMap commandMap;
        Constructor ctr;
        playerSuggestionProvider = (args, sender, command) -> Bukkit.getOnlinePlayers().stream().filter(player -> !((BukkitCommandActor)sender).isPlayer() || ((BukkitCommandActor)sender).requirePlayer().canSee(player)).map(HumanEntity::getName).collect(Collectors.toList());
        Field knownCommands = null;
        try {
            ctr = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
            ctr.setAccessible(true);
            Field commandMapField = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            commandMap = (CommandMap)commandMapField.get(Bukkit.getServer());
            if (commandMap instanceof SimpleCommandMap) {
                knownCommands = SimpleCommandMap.class.getDeclaredField("knownCommands");
                knownCommands.setAccessible(true);
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Unable to access PluginCommand(String, Plugin) construtor!");
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            throw new IllegalStateException("Unable to access Bukkit.getServer()#commandMap!");
        }
        COMMAND_CONSTRUCTOR = ctr;
        COMMAND_MAP = commandMap;
        KNOWN_COMMANDS = knownCommands;
    }
}

