/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.axapi.gui.inventory;

import com.artillexstudios.axvaults.libs.axapi.AxPlugin;
import com.artillexstudios.axvaults.libs.axapi.executor.ExceptionReportingScheduledThreadPool;
import com.artillexstudios.axvaults.libs.axapi.gui.inventory.Gui;
import com.artillexstudios.axvaults.libs.axapi.gui.inventory.renderer.InventoryRenderer;
import com.artillexstudios.axvaults.libs.axapi.gui.inventory.renderer.InventoryRenderers;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public enum InventoryUpdater {
    INSTANCE;

    private ScheduledExecutorService service;

    public void start(AxPlugin plugin) {
        this.service = new ExceptionReportingScheduledThreadPool(1, Thread.ofPlatform().name(plugin.getName() + "-AxAPI-inventory-updater").factory());
        this.service.scheduleWithFixedDelay(() -> {
            for (InventoryRenderer renderer : InventoryRenderers.getCurrentRenderers()) {
                Gui gui = renderer.getCurrentGui();
                if (gui == null || renderer.isClosed()) continue;
                gui.tick();
            }
        }, 0L, 50L, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        if (this.service == null || this.service.isShutdown()) {
            return;
        }
        this.service.shutdown();
    }
}

