/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.database.messaging;

import com.artillexstudios.axvaults.AxVaults;
import com.artillexstudios.axvaults.database.Database;
import com.artillexstudios.axvaults.database.impl.MySQL;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class SQLMessaging {
    private static ScheduledExecutorService executor = null;

    public static void start() {
        String support = AxVaults.CONFIG.getString("multi-server-support", null);
        if (support == null) {
            return;
        }
        if (support.equalsIgnoreCase("none")) {
            AxVaults.CONFIG.remove("multi-server-support");
            AxVaults.CONFIG.save();
            return;
        }
        Database database = AxVaults.getDatabase();
        if (!(database instanceof MySQL)) {
            AxVaults.CONFIG.remove("multi-server-support");
            AxVaults.CONFIG.save();
            return;
        }
        MySQL db = (MySQL)database;
        if (executor != null) {
            executor.shutdown();
        }
        executor = Executors.newSingleThreadScheduledExecutor();
        executor.scheduleAtFixedRate(db::checkForChanges, 5L, 5L, TimeUnit.SECONDS);
        executor.scheduleAtFixedRate(db::removeOldChanges, 10L, 10L, TimeUnit.SECONDS);
    }

    public static void stop() {
        if (executor == null) {
            return;
        }
        executor.shutdown();
    }
}

