/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.axapi.packet;

import com.artillexstudios.axvaults.libs.axapi.items.WrappedItemStack;
import com.artillexstudios.axvaults.libs.axapi.items.nbt.CompoundTag;
import com.artillexstudios.axvaults.libs.axapi.nms.NMSHandlers;
import com.artillexstudios.axvaults.libs.axapi.packet.ClientboundPacketTypes;
import com.artillexstudios.axvaults.libs.axapi.packet.PacketType;
import com.artillexstudios.axvaults.libs.axapi.packet.ServerboundPacketTypes;
import com.artillexstudios.axvaults.libs.axapi.utils.Vector3d;
import com.artillexstudios.axvaults.libs.axapi.utils.Vector3f;
import com.artillexstudios.axvaults.libs.axapi.utils.Version;
import com.artillexstudios.axvaults.libs.axapi.utils.position.BlockPosition;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.bukkit.block.data.BlockData;

public interface FriendlyByteBuf {
    public static FriendlyByteBuf alloc() {
        return NMSHandlers.getNmsHandler().newBuf();
    }

    default public WrappedItemStack readItemStack() {
        return this.readItemStack(WrappedItemStack.CodecData.OPTIONAL_STREAM_CODEC);
    }

    public WrappedItemStack readItemStack(WrappedItemStack.CodecData var1);

    default public void writeItemStack(WrappedItemStack wrappedItemStack) {
        this.writeItemStack(wrappedItemStack, WrappedItemStack.CodecData.OPTIONAL_STREAM_CODEC);
    }

    public void writeItemStack(WrappedItemStack var1, WrappedItemStack.CodecData var2);

    public byte[] readByteArray();

    public byte[] readByteArray(int var1);

    public void writeByteArray(byte[] var1);

    public Component readComponent();

    public void writeComponent(Component var1);

    public int readVarInt();

    public void writeVarInt(int var1);

    public CompoundTag readNBT();

    public void writeNBT(CompoundTag var1);

    public String readUTF();

    public String readUTF(int var1);

    public void writeUTF(String var1);

    public Key readResourceLocation();

    public void writeResourceLocation(Key var1);

    public void writeFloat(float var1);

    public float readFloat();

    public void writeShort(int var1);

    public short readShort();

    public void writeDouble(double var1);

    public double readDouble();

    public void writeBoolean(boolean var1);

    public boolean readBoolean();

    public void writeInt(int var1);

    public int readInt();

    public void writeVarLong(long var1);

    public long readVarLong();

    public void writeLong(long var1);

    public long readLong();

    public void writeByte(int var1);

    public byte readByte();

    public short readUnsignedByte();

    public void readerIndex(int var1);

    public int readerIndex();

    public void writerIndex(int var1);

    public int writerIndex();

    public WrappedItemStack readItemCost();

    public void writeItemCost(WrappedItemStack var1);

    public Optional<WrappedItemStack> readOptionalItemCost();

    public void writeOptionalItemCost(Optional<WrappedItemStack> var1);

    public int readUnsignedShort();

    public void writeBlockData(BlockData var1);

    public BlockData readBlockData();

    public Vector3d readLpVec3();

    public void writeLpVec3(Vector3d var1);

    public void writeBytes(FriendlyByteBuf var1);

    public FriendlyByteBuf readBytes(int var1);

    public FriendlyByteBuf copy();

    public FriendlyByteBuf slice(int var1, int var2);

    public int readableBytes();

    public void release();

    default public <T extends Enum<T>> T readEnum(Class<T> clazz) {
        return (T)((Enum[])clazz.getEnumConstants())[this.readVarInt()];
    }

    default public <T extends Enum<T>> void writeEnum(T constant) {
        this.writeVarInt(constant.ordinal());
    }

    default public Vector3f readVector3f() {
        return new Vector3f(this.readFloat(), this.readFloat(), this.readFloat());
    }

    default public void writeVector3f(Vector3f value) {
        this.writeFloat(value.x());
        this.writeFloat(value.y());
        this.writeFloat(value.z());
    }

    default public void writeBlockPos(BlockPosition blockPosition) {
        this.writeLong(blockPosition.asLong());
    }

    default public BlockPosition readBlockPosition() {
        return BlockPosition.of(this.readLong());
    }

    default public int readContainerId() {
        if (Version.getServerVersion().isNewerThanOrEqualTo(Version.v1_21_2)) {
            return this.readVarInt();
        }
        return this.readUnsignedByte();
    }

    default public void writeContainerId(int containerId) {
        if (Version.getServerVersion().isNewerThanOrEqualTo(Version.v1_21_2)) {
            this.writeVarInt(containerId);
        } else {
            this.writeByte((byte)containerId);
        }
    }

    default public void writePacketType(PacketType packetType) {
        int packetId = ClientboundPacketTypes.forPacketType(packetType);
        if (packetId == -1) {
            packetId = ServerboundPacketTypes.forPacketType(packetType);
        }
        if (packetId == -1) {
            throw new IllegalArgumentException();
        }
        this.writeVarInt(packetId);
    }

    default public void writeUUID(UUID uuid) {
        this.writeLong(uuid.getMostSignificantBits());
        this.writeLong(uuid.getLeastSignificantBits());
    }

    default public UUID readUUID() {
        return new UUID(this.readLong(), this.readLong());
    }

    default public int[] readVarIntArray() {
        int readableBytes = this.readableBytes();
        int size = this.readVarInt();
        if (size > readableBytes) {
            throw new IllegalStateException();
        }
        int[] array = new int[size];
        for (int i = 0; i < size; ++i) {
            array[i] = this.readVarInt();
        }
        return array;
    }

    default public void versionedWriteLpVec3(Vector3d vector) {
        if (Version.getServerVersion().isOlderThanOrEqualTo(Version.v1_21_6)) {
            this.writeShort((int)(Math.clamp(vector.x(), -3.9, 3.9) * 8000.0));
            this.writeShort((int)(Math.clamp(vector.y(), -3.9, 3.9) * 8000.0));
            this.writeShort((int)(Math.clamp(vector.z(), -3.9, 3.9) * 8000.0));
        } else {
            this.writeLpVec3(vector);
        }
    }

    default public Vector3d versionedReadLpVec3() {
        if (Version.getServerVersion().isOlderThanOrEqualTo(Version.v1_21_6)) {
            return new Vector3d(this.readShort(), this.readShort(), this.readShort());
        }
        return this.readLpVec3();
    }

    default public void writeVarIntArray(int[] array) {
        this.writeVarInt(array.length);
        for (int i : array) {
            this.writeVarInt(i);
        }
    }
}

