/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.guis;

import com.artillexstudios.axvaults.AxVaults;
import com.artillexstudios.axvaults.guis.VaultSelector;
import com.artillexstudios.axvaults.libs.axapi.libs.boostedyaml.block.implementation.Section;
import com.artillexstudios.axvaults.libs.axapi.reflection.ClassUtils;
import com.artillexstudios.axvaults.libs.axapi.utils.ItemBuilder;
import com.artillexstudios.axvaults.libs.axapi.utils.StringUtils;
import com.artillexstudios.axvaults.libs.gui.builder.gui.PaginatedBuilder;
import com.artillexstudios.axvaults.libs.gui.guis.Gui;
import com.artillexstudios.axvaults.libs.gui.guis.GuiItem;
import com.artillexstudios.axvaults.libs.gui.guis.PaginatedGui;
import com.artillexstudios.axvaults.utils.SoundUtils;
import com.artillexstudios.axvaults.vaults.Vault;
import java.util.Objects;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class ItemPicker {
    public void open(@NotNull Player player, @NotNull Vault vault) {
        this.open(player, vault, 1, 1);
    }

    public void open(@NotNull Player player, @NotNull Vault vault, int oldPage, int cPage) {
        Section back;
        Section next;
        int rows = AxVaults.CONFIG.getInt("item-picker-rows", 6);
        int pageSize = rows * 9 - 9;
        String title = AxVaults.MESSAGES.getString("guis.item-picker.title");
        if (ClassUtils.INSTANCE.classExists("me.clip.placeholderapi.PlaceholderAPI")) {
            title = PlaceholderAPI.setPlaceholders((Player)player, (String)title);
        }
        PaginatedGui gui = ((PaginatedBuilder)((PaginatedBuilder)((PaginatedBuilder)Gui.paginated().title(StringUtils.format(title, new TagResolver[0]))).rows(rows)).pageSize(pageSize).disableAllInteractions()).create();
        for (Material material : Material.values()) {
            ItemMeta meta;
            ItemStack it = null;
            try {
                it = ItemBuilder.create(material).glow(Objects.equals(vault.getIcon(), material)).get();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (it == null) continue;
            ItemMeta itemMeta = meta = it.hasItemMeta() ? it.getItemMeta() : Bukkit.getItemFactory().getItemMeta(it.getType());
            if (meta == null) continue;
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            it.setItemMeta(meta);
            GuiItem guiItem = new GuiItem(it);
            guiItem.setAction(event -> {
                if (vault.getIcon().equals((Object)material)) {
                    vault.setIcon(null);
                } else {
                    vault.setIcon(material);
                }
                SoundUtils.playSound(player, AxVaults.MESSAGES.getString("sounds.select-icon"));
                if (AxVaults.CONFIG.getBoolean("selector-stay-open", true)) {
                    this.open(player, vault, oldPage, gui.getCurrentPageNum());
                } else {
                    new VaultSelector().open(player, oldPage);
                }
            });
            gui.addItem(guiItem);
        }
        Section prev = AxVaults.MESSAGES.getSection("gui-items.previous-page");
        if (prev != null) {
            GuiItem item1 = new GuiItem(ItemBuilder.create(prev).get());
            item1.setAction(event -> gui.previous());
            gui.setItem(rows, 3, item1);
        }
        if ((next = AxVaults.MESSAGES.getSection("gui-items.next-page")) != null) {
            GuiItem item2 = new GuiItem(ItemBuilder.create(next).get());
            item2.setAction(event -> gui.next());
            gui.setItem(rows, 7, item2);
        }
        if ((back = AxVaults.MESSAGES.getSection("gui-items.back")) != null) {
            GuiItem item3 = new GuiItem(ItemBuilder.create(back).get());
            item3.setAction(event -> new VaultSelector().open(player, oldPage));
            gui.setItem(rows, 5, item3);
        }
        gui.open((HumanEntity)player, cPage);
    }
}

