/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults;

import com.artillexstudios.axvaults.commands.CommandManager;
import com.artillexstudios.axvaults.database.Database;
import com.artillexstudios.axvaults.database.impl.H2;
import com.artillexstudios.axvaults.database.impl.MySQL;
import com.artillexstudios.axvaults.database.impl.SQLite;
import com.artillexstudios.axvaults.database.messaging.SQLMessaging;
import com.artillexstudios.axvaults.hooks.HookManager;
import com.artillexstudios.axvaults.libraries.Libraries;
import com.artillexstudios.axvaults.libs.axapi.AxPlugin;
import com.artillexstudios.axvaults.libs.axapi.config.Config;
import com.artillexstudios.axvaults.libs.axapi.dependencies.DependencyManagerWrapper;
import com.artillexstudios.axvaults.libs.axapi.executor.ThreadedQueue;
import com.artillexstudios.axvaults.libs.axapi.libs.boostedyaml.dvs.versioning.BasicVersioning;
import com.artillexstudios.axvaults.libs.axapi.libs.boostedyaml.settings.dumper.DumperSettings;
import com.artillexstudios.axvaults.libs.axapi.libs.boostedyaml.settings.general.GeneralSettings;
import com.artillexstudios.axvaults.libs.axapi.libs.boostedyaml.settings.loader.LoaderSettings;
import com.artillexstudios.axvaults.libs.axapi.libs.boostedyaml.settings.updater.UpdaterSettings;
import com.artillexstudios.axvaults.libs.axapi.metrics.AxMetrics;
import com.artillexstudios.axvaults.libs.axapi.utils.MessageUtils;
import com.artillexstudios.axvaults.libs.axapi.utils.StringUtils;
import com.artillexstudios.axvaults.libs.axapi.utils.featureflags.FeatureFlags;
import com.artillexstudios.axvaults.libs.bstats.bukkit.Metrics;
import com.artillexstudios.axvaults.listeners.BlacklistListener;
import com.artillexstudios.axvaults.listeners.BlockBreakListener;
import com.artillexstudios.axvaults.listeners.InventoryClickListener;
import com.artillexstudios.axvaults.listeners.InventoryCloseListener;
import com.artillexstudios.axvaults.listeners.PlayerInteractListener;
import com.artillexstudios.axvaults.listeners.PlayerListeners;
import com.artillexstudios.axvaults.schedulers.AutoSaveScheduler;
import com.artillexstudios.axvaults.utils.UpdateNotifier;
import com.artillexstudios.axvaults.utils.VaultUtils;
import com.artillexstudios.axvaults.vaults.Vault;
import com.artillexstudios.axvaults.vaults.VaultManager;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import revxrsal.zapper.DependencyManager;
import revxrsal.zapper.relocation.Relocation;

public final class AxVaults
extends AxPlugin {
    private static boolean stopping = false;
    public static Config CONFIG;
    public static Config MESSAGES;
    public static MessageUtils MESSAGEUTILS;
    private static AxPlugin instance;
    private static ThreadedQueue<Runnable> threadedQueue;
    private static Database database;
    private static AxMetrics metrics;

    public static ThreadedQueue<Runnable> getThreadedQueue() {
        return threadedQueue;
    }

    public static AxPlugin getInstance() {
        return instance;
    }

    public static Database getDatabase() {
        return database;
    }

    public static boolean isStopping() {
        return stopping;
    }

    @Override
    public void dependencies(DependencyManagerWrapper manager) {
        instance = this;
        DependencyManager dependencyManager = manager.wrapped();
        for (Libraries lib : Libraries.values()) {
            dependencyManager.dependency(lib.fetchLibrary());
            for (Relocation relocation : lib.relocations()) {
                dependencyManager.relocate(relocation);
            }
        }
    }

    @Override
    public void enable() {
        new Metrics((Plugin)this, 20541);
        CONFIG = new Config(new File(this.getDataFolder(), "config.yml"), this.getResource("config.yml"), GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setKeepAll(true).setVersioning(new BasicVersioning("version")).build());
        MESSAGES = new Config(new File(this.getDataFolder(), "messages.yml"), this.getResource("messages.yml"), GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setKeepAll(true).setVersioning(new BasicVersioning("version")).build());
        MESSAGEUTILS = new MessageUtils(MESSAGES.getBackingDocument(), "prefix", CONFIG.getBackingDocument());
        threadedQueue = new ThreadedQueue("AxVaults-Datastore-thread");
        VaultUtils.reload();
        HookManager.setupHooks();
        database = switch (CONFIG.getString("database.type").toLowerCase()) {
            case "sqlite" -> new SQLite();
            case "mysql" -> new MySQL();
            default -> new H2();
        };
        database.setup();
        threadedQueue.submit(() -> database.load());
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListeners(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BlacklistListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerInteractListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BlockBreakListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryCloseListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryClickListener(), (Plugin)this);
        CommandManager.load();
        AutoSaveScheduler.start();
        SQLMessaging.start();
        metrics = new AxMetrics(this, 3L);
        metrics.start();
        Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#55ff00[AxVaults] Loaded plugin!", new TagResolver[0]));
        if (CONFIG.getBoolean("update-notifier.enabled", true)) {
            new UpdateNotifier(this, 5417);
        }
    }

    @Override
    public void disable() {
        stopping = true;
        if (metrics != null) {
            metrics.cancel();
        }
        for (Vault vault : VaultManager.getVaults()) {
            for (HumanEntity humanEntity : new ArrayList(vault.getInventory().getViewers())) {
                humanEntity.closeInventory();
            }
        }
        AutoSaveScheduler.stop();
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (Vault vault : VaultManager.getVaults()) {
            futures.add(AxVaults.getDatabase().saveVault(vault));
        }
        CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)).join();
        SQLMessaging.stop();
        database.disable();
        threadedQueue.stop();
    }

    @Override
    public void updateFlags() {
        FeatureFlags.USE_LEGACY_HEX_FORMATTER.set(true);
    }
}

