/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.vaults;

import com.artillexstudios.axvaults.AxVaults;
import com.artillexstudios.axvaults.libs.axapi.reflection.ClassUtils;
import com.artillexstudios.axvaults.libs.axapi.utils.StringUtils;
import com.artillexstudios.axvaults.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import com.artillexstudios.axvaults.utils.SoundUtils;
import com.artillexstudios.axvaults.vaults.VaultManager;
import com.artillexstudios.axvaults.vaults.VaultPlayer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Vault {
    private final UUID uuid;
    private Inventory storage;
    private final int id;
    private Material icon;
    private VaultPlayer vaultPlayer;
    private long lastOpen = System.currentTimeMillis();
    private CompletableFuture<Void> future = new CompletableFuture();

    public Vault(UUID uuid, int num, Material icon) {
        this.uuid = uuid;
        this.id = num;
        VaultManager.getPlayer(uuid, vaultPlayer -> {
            this.vaultPlayer = vaultPlayer;
            String title = AxVaults.MESSAGES.getString("guis.vault.title").replace("%num%", "" + num);
            if (ClassUtils.INSTANCE.classExists("me.clip.placeholderapi.PlaceholderAPI")) {
                title = PlaceholderAPI.setPlaceholders((OfflinePlayer)Bukkit.getOfflinePlayer((UUID)uuid), (String)title);
            }
            this.storage = Bukkit.createInventory(null, (int)(vaultPlayer.getRows() * 9), (String)StringUtils.formatToString(title, new TagResolver[0]));
            this.future.complete(null);
            this.future = null;
            vaultPlayer.getVaultMap().put(num, this);
        });
        this.icon = icon;
        VaultManager.getVaults().add(this);
    }

    public void setContents(ItemStack[] items, Consumer<Void> consumer) {
        if (this.future == null) {
            this.storage.setContents(items);
            consumer.accept(null);
            return;
        }
        this.future.thenRun(() -> {
            this.storage.setContents(items);
            consumer.accept(null);
        });
    }

    public Inventory getStorage() {
        return this.storage;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public int getId() {
        return this.id;
    }

    public long getLastOpen() {
        return this.lastOpen;
    }

    public void setIcon(Material icon) {
        this.icon = icon;
    }

    public Material getIcon() {
        if (this.icon == null) {
            return Material.valueOf((String)AxVaults.MESSAGES.getString("guis.selector.item-owned.material", "BARREL"));
        }
        return this.icon;
    }

    @Nullable
    public Material getRealIcon() {
        return this.icon;
    }

    public int getSlotsFilled() {
        int am = 0;
        for (ItemStack it : this.storage.getContents()) {
            if (it == null) continue;
            ++am;
        }
        return am;
    }

    public void open(@NotNull Player player) {
        if (this.vaultPlayer.getRows() != this.storage.getSize()) {
            this.reload();
        }
        player.openInventory(this.storage);
        SoundUtils.playSound(player, AxVaults.MESSAGES.getString("sounds.open"));
        this.lastOpen = System.currentTimeMillis();
    }

    public boolean isOpened() {
        return !this.storage.getViewers().isEmpty();
    }

    public void reload() {
        String title = AxVaults.MESSAGES.getString("guis.vault.title").replace("%num%", "" + this.id);
        if (ClassUtils.INSTANCE.classExists("me.clip.placeholderapi.PlaceholderAPI")) {
            title = PlaceholderAPI.setPlaceholders((OfflinePlayer)Bukkit.getOfflinePlayer((UUID)this.uuid), (String)title);
        }
        Inventory newStorage = Bukkit.createInventory(null, (int)(this.vaultPlayer.getRows() * 9), (String)StringUtils.formatToString(title, new TagResolver[0]));
        ItemStack[] contents = this.storage.getContents();
        int n = -1;
        for (ItemStack it : contents) {
            if (++n > newStorage.getSize() - 1) {
                if (it == null) continue;
                newStorage.addItem(new ItemStack[]{it});
                continue;
            }
            newStorage.setItem(n, it);
        }
        ArrayList viewers = new ArrayList(this.storage.getViewers());
        Iterator viewerIterator = viewers.iterator();
        while (viewerIterator.hasNext()) {
            ((HumanEntity)viewerIterator.next()).openInventory(newStorage);
            viewerIterator.remove();
        }
        this.storage = newStorage;
    }
}

