/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.schedulers;

import com.artillexstudios.axvaults.AxVaults;
import com.artillexstudios.axvaults.vaults.Vault;
import com.artillexstudios.axvaults.vaults.VaultManager;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;

public class AutoSaveScheduler {
    private static ScheduledExecutorService service = null;

    public static void start() {
        int time = AxVaults.CONFIG.getInt("auto-save-minutes");
        if (service != null) {
            service.shutdown();
        }
        service = Executors.newSingleThreadScheduledExecutor();
        service.scheduleAtFixedRate(() -> {
            try {
                Iterator<Vault> iterator = VaultManager.getVaults().iterator();
                while (iterator.hasNext()) {
                    Vault vault = iterator.next();
                    AxVaults.getDatabase().saveVault(vault);
                    if (vault.isOpened() || Bukkit.getPlayer((UUID)vault.getUUID()) != null || System.currentTimeMillis() - vault.getLastOpen() <= (long)(time - 1) * 1000L) continue;
                    VaultManager.removeVault(vault);
                    iterator.remove();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }, time, time, TimeUnit.MINUTES);
    }

    public static void stop() {
        if (service == null) {
            return;
        }
        service.shutdown();
    }
}

