/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.lamp.bukkit.brigadier;

import com.artillexstudios.axvaults.libs.lamp.bukkit.BukkitCommandHandler;
import com.artillexstudios.axvaults.libs.lamp.bukkit.brigadier.Commodore;
import com.artillexstudios.axvaults.libs.lamp.bukkit.brigadier.ReflectionUtil;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandSendEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.plugin.Plugin;

final class ReflectionCommodore
extends Commodore {
    private static final Field CONSOLE_FIELD;
    private static final Method GET_COMMAND_DISPATCHER_METHOD;
    private static final Method GET_BRIGADIER_DISPATCHER_METHOD;
    private final Plugin plugin;
    private final List<LiteralCommandNode<?>> registeredNodes = new ArrayList();

    ReflectionCommodore(BukkitCommandHandler handler) {
        this.plugin = handler.getPlugin();
        this.plugin.getServer().getPluginManager().registerEvents((Listener)new ServerReloadListener(), this.plugin);
    }

    private CommandDispatcher<?> getDispatcher() {
        try {
            Object mcServerObject = CONSOLE_FIELD.get(Bukkit.getServer());
            Object commandDispatcherObject = GET_COMMAND_DISPATCHER_METHOD.invoke(mcServerObject, new Object[0]);
            return (CommandDispatcher)GET_BRIGADIER_DISPATCHER_METHOD.invoke(commandDispatcherObject, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void register(LiteralCommandNode<?> node) {
        Objects.requireNonNull(node, "node");
        CommandDispatcher<?> dispatcher = this.getDispatcher();
        RootCommandNode root = dispatcher.getRoot();
        ReflectionCommodore.removeChild(root, node.getName());
        root.addChild(node);
        this.registeredNodes.add(node);
    }

    @Override
    public void register(Command command, LiteralCommandNode<?> node) {
        Objects.requireNonNull(command, "command");
        Objects.requireNonNull(node, "node");
        Collection<String> aliases = ReflectionCommodore.getAliases(command);
        if (!aliases.contains(node.getLiteral())) {
            node = ReflectionCommodore.renameLiteralNode(node, command.getName());
        }
        for (String alias : aliases) {
            if (node.getLiteral().equals(alias)) {
                this.register(node);
                continue;
            }
            this.register(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)alias).redirect(node)).build());
        }
        this.plugin.getServer().getPluginManager().registerEvents((Listener)new CommandDataSendListener(command), this.plugin);
    }

    static void ensureSetup() {
    }

    static {
        try {
            Class<?> commandDispatcher;
            Class<?> minecraftServer;
            if (ReflectionUtil.minecraftVersion() >= 19) {
                throw new UnsupportedOperationException("ReflectionCommodore is not supported on MC 1.19 or above. Switch to Paper :)");
            }
            if (ReflectionUtil.minecraftVersion() > 16) {
                minecraftServer = ReflectionUtil.mcClass("server.MinecraftServer");
                commandDispatcher = ReflectionUtil.mcClass("commands.CommandDispatcher");
            } else {
                minecraftServer = ReflectionUtil.nmsClass("MinecraftServer");
                commandDispatcher = ReflectionUtil.nmsClass("CommandDispatcher");
            }
            Class<?> craftServer = ReflectionUtil.obcClass("CraftServer");
            CONSOLE_FIELD = craftServer.getDeclaredField("console");
            CONSOLE_FIELD.setAccessible(true);
            GET_COMMAND_DISPATCHER_METHOD = Arrays.stream(minecraftServer.getDeclaredMethods()).filter(method -> method.getParameterCount() == 0).filter(method -> commandDispatcher.isAssignableFrom(method.getReturnType())).findFirst().orElseThrow(NoSuchMethodException::new);
            GET_COMMAND_DISPATCHER_METHOD.setAccessible(true);
            GET_BRIGADIER_DISPATCHER_METHOD = Arrays.stream(commandDispatcher.getDeclaredMethods()).filter(method -> method.getParameterCount() == 0).filter(method -> CommandDispatcher.class.isAssignableFrom(method.getReturnType())).findFirst().orElseThrow(NoSuchMethodException::new);
            GET_BRIGADIER_DISPATCHER_METHOD.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static final class CommandDataSendListener
    implements Listener {
        private final Set<String> minecraftPrefixedAliases;

        CommandDataSendListener(Command pluginCommand) {
            this.minecraftPrefixedAliases = Commodore.getAliases(pluginCommand).stream().map(alias -> "minecraft:" + alias).collect(Collectors.toSet());
        }

        @EventHandler
        public void onCommandSend(PlayerCommandSendEvent e) {
            e.getCommands().removeAll(this.minecraftPrefixedAliases);
        }
    }

    private final class ServerReloadListener
    implements Listener {
        private ServerReloadListener() {
        }

        @EventHandler
        public void onLoad(ServerLoadEvent e) {
            CommandDispatcher dispatcher = ReflectionCommodore.this.getDispatcher();
            RootCommandNode root = dispatcher.getRoot();
            for (LiteralCommandNode node : ReflectionCommodore.this.registeredNodes) {
                Commodore.removeChild(root, node.getName());
                root.addChild((CommandNode)node);
            }
        }

        @EventHandler
        public void onPluginDisable(PluginDisableEvent e) {
            if (ReflectionCommodore.this.plugin != e.getPlugin()) {
                return;
            }
            CommandDispatcher dispatcher = ReflectionCommodore.this.getDispatcher();
            RootCommandNode root = dispatcher.getRoot();
            for (LiteralCommandNode node : ReflectionCommodore.this.registeredNodes) {
                Commodore.removeChild(root, node.getName());
            }
        }
    }
}

