/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.lamp.bukkit.brigadier;

import com.artillexstudios.axvaults.libs.lamp.bukkit.BukkitCommandHandler;
import com.artillexstudios.axvaults.libs.lamp.bukkit.brigadier.Commodore;
import com.artillexstudios.axvaults.libs.lamp.bukkit.brigadier.PaperCommodore;
import com.artillexstudios.axvaults.libs.lamp.bukkit.brigadier.ReflectionCommodore;
import java.util.Objects;
import java.util.function.Function;

public final class CommodoreProvider {
    private static final Function<BukkitCommandHandler, Commodore> PROVIDER = CommodoreProvider.checkSupported();

    private CommodoreProvider() {
        throw new AssertionError();
    }

    private static Function<BukkitCommandHandler, Commodore> checkSupported() {
        try {
            Class.forName("com.mojang.brigadier.CommandDispatcher");
        }
        catch (Throwable e) {
            CommodoreProvider.printDebugInfo(e);
            return null;
        }
        try {
            ReflectionCommodore.ensureSetup();
            return plugin -> new ReflectionCommodore((BukkitCommandHandler)plugin);
        }
        catch (Throwable e) {
            CommodoreProvider.printDebugInfo(e);
            try {
                PaperCommodore.ensureSetup();
                return plugin -> new PaperCommodore((BukkitCommandHandler)plugin);
            }
            catch (Throwable e2) {
                CommodoreProvider.printDebugInfo(e2);
                return null;
            }
        }
    }

    private static void printDebugInfo(Throwable e) {
        if (System.getProperty("commodore.debug") != null) {
            System.err.println("Exception while initialising commodore:");
            e.printStackTrace(System.err);
        }
    }

    public static boolean isSupported() {
        return PROVIDER != null;
    }

    public static Commodore getCommodore(BukkitCommandHandler plugin) {
        Objects.requireNonNull(plugin, "plugin");
        return PROVIDER == null ? null : PROVIDER.apply(plugin);
    }
}

