/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.lamp.bukkit.brigadier;

import com.artillexstudios.axvaults.libs.lamp.bukkit.brigadier.ReflectionUtil;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;

abstract class Commodore {
    protected static final Field CUSTOM_SUGGESTIONS_FIELD;
    protected static final Field COMMAND_EXECUTE_FUNCTION_FIELD;
    protected static final Field CHILDREN_FIELD;
    protected static final Field LITERALS_FIELD;
    protected static final Field ARGUMENTS_FIELD;
    private static final Method GET_BUKKIT_SENDER_METHOD;
    protected static final Field[] CHILDREN_FIELDS;
    protected static final com.mojang.brigadier.Command<?> DUMMY_COMMAND;
    protected static final SuggestionProvider<?> DUMMY_SUGGESTION_PROVIDER;

    Commodore() {
    }

    protected static void removeChild(RootCommandNode root, String name) {
        try {
            for (Field field : CHILDREN_FIELDS) {
                Map children = (Map)field.get(root);
                children.remove(name);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    protected static <S> LiteralCommandNode<S> renameLiteralNode(LiteralCommandNode<S> node, String newLiteral) {
        LiteralCommandNode clone = new LiteralCommandNode(newLiteral, node.getCommand(), node.getRequirement(), node.getRedirect(), node.getRedirectModifier(), node.isFork());
        for (CommandNode child : node.getChildren()) {
            clone.addChild(child);
        }
        return clone;
    }

    public CommandSender getBukkitSender(Object commandSource) {
        Objects.requireNonNull(commandSource, "commandSource");
        try {
            return (CommandSender)GET_BUKKIT_SENDER_METHOD.invoke(commandSource, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    protected static Collection<String> getAliases(Command command) {
        Objects.requireNonNull(command, "command");
        Stream<String> aliasesStream = Stream.concat(Stream.of(command.getLabel()), command.getAliases().stream());
        if (command instanceof PluginCommand) {
            String fallbackPrefix = ((PluginCommand)command).getPlugin().getName().toLowerCase().trim();
            aliasesStream = aliasesStream.flatMap(alias -> Stream.of(alias, fallbackPrefix + ":" + alias));
        }
        return aliasesStream.distinct().collect(Collectors.toList());
    }

    abstract void register(Command var1, LiteralCommandNode<?> var2);

    abstract void register(LiteralCommandNode<?> var1);

    static {
        try {
            Class<?> commandListenerWrapper = ReflectionUtil.minecraftVersion() > 16 ? ReflectionUtil.mcClass("commands.CommandListenerWrapper") : ReflectionUtil.nmsClass("CommandListenerWrapper");
            CUSTOM_SUGGESTIONS_FIELD = ArgumentCommandNode.class.getDeclaredField("customSuggestions");
            CUSTOM_SUGGESTIONS_FIELD.setAccessible(true);
            COMMAND_EXECUTE_FUNCTION_FIELD = CommandNode.class.getDeclaredField("command");
            COMMAND_EXECUTE_FUNCTION_FIELD.setAccessible(true);
            CHILDREN_FIELD = CommandNode.class.getDeclaredField("children");
            LITERALS_FIELD = CommandNode.class.getDeclaredField("literals");
            ARGUMENTS_FIELD = CommandNode.class.getDeclaredField("arguments");
            for (Field field : CHILDREN_FIELDS = new Field[]{CHILDREN_FIELD, LITERALS_FIELD, ARGUMENTS_FIELD}) {
                field.setAccessible(true);
            }
            GET_BUKKIT_SENDER_METHOD = commandListenerWrapper.getDeclaredMethod("getBukkitSender", new Class[0]);
            GET_BUKKIT_SENDER_METHOD.setAccessible(true);
            DUMMY_COMMAND = ctx -> {
                throw new UnsupportedOperationException();
            };
            DUMMY_SUGGESTION_PROVIDER = (context, builder) -> {
                throw new UnsupportedOperationException();
            };
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

