/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.gui.settings;

import com.artillexstudios.axvaults.libs.gui.click.handler.ClickHandler;
import com.artillexstudios.axvaults.libs.gui.click.handler.SimpleClickHandler;
import com.artillexstudios.axvaults.libs.gui.component.renderer.DefaultGuiComponentRenderer;
import com.artillexstudios.axvaults.libs.gui.component.renderer.GuiComponentRenderer;
import org.jetbrains.annotations.NotNull;

public abstract class GuiSettings<P, I, S extends GuiSettings<P, I, S>> {
    private ClickHandler<P> clickHandler = new SimpleClickHandler();
    private GuiComponentRenderer<P, I> componentRenderer = new DefaultGuiComponentRenderer();
    private long spamPreventionDuration = 200L;

    public S clickHandler(@NotNull ClickHandler<P> clickHandler) {
        this.clickHandler = clickHandler;
        return (S)this;
    }

    public S componentRenderer(@NotNull GuiComponentRenderer<P, I> componentRenderer) {
        this.componentRenderer = componentRenderer;
        return (S)this;
    }

    public S spamPreventionDuration(long spamPreventionDuration) {
        if (spamPreventionDuration < 0L) {
            throw new IllegalArgumentException("Spam prevention duration cannot be negative!");
        }
        this.spamPreventionDuration = spamPreventionDuration;
        return (S)this;
    }

    @NotNull
    public ClickHandler<P> getClickHandler() {
        return this.clickHandler;
    }

    @NotNull
    public GuiComponentRenderer<P, I> getComponentRenderer() {
        return this.componentRenderer;
    }

    public long getSpamPreventionDuration() {
        return this.spamPreventionDuration;
    }
}

