/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.gui.click.processor;

import com.artillexstudios.axvaults.libs.gui.AbstractGuiView;
import com.artillexstudios.axvaults.libs.gui.click.ClickContext;
import com.artillexstudios.axvaults.libs.gui.click.action.EmptyGuiClickAction;
import com.artillexstudios.axvaults.libs.gui.click.action.GuiClickAction;
import com.artillexstudios.axvaults.libs.gui.click.controller.DefaultClickController;
import com.artillexstudios.axvaults.libs.gui.click.handler.ClickHandler;
import com.artillexstudios.axvaults.libs.gui.item.RenderedGuiItem;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.LocalTime;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClickProcessor<P, I> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClickProcessor.class);
    private final long spamPreventionDuration;
    private final Cache<UUID, LocalTime> spamPrevention;
    private boolean isProcessing = false;

    public ClickProcessor(long spamPreventionDuration) {
        this.spamPreventionDuration = spamPreventionDuration;
        this.spamPrevention = CacheBuilder.newBuilder().expireAfterWrite(spamPreventionDuration, TimeUnit.MILLISECONDS).build();
    }

    public void processClick(int slot, @NotNull AbstractGuiView<P, I> view) {
        UUID viewerUuid = view.viewerUuid();
        if (!this.canClick(viewerUuid)) {
            return;
        }
        RenderedGuiItem<P, I> renderedItem = view.getItem(slot);
        if (renderedItem == null) {
            return;
        }
        GuiClickAction<P> action = renderedItem.action();
        if (action instanceof EmptyGuiClickAction) {
            return;
        }
        this.isProcessing = true;
        ClickContext clickContext = new ClickContext();
        ClickHandler<P> handler = renderedItem.clickHandler();
        DefaultClickController clickController = new DefaultClickController((ignored, throwable) -> {
            if (throwable != null) {
                LOGGER.error("An exception occurred while processing click for '{}' on slot '{}'.", new Object[]{view.viewerName(), slot, throwable});
            }
            this.isProcessing = false;
        });
        Exception handledException = null;
        try {
            handler.handle(view.viewer(), clickContext, action, clickController);
        }
        catch (Exception exception) {
            handledException = exception;
        }
        if (!clickController.completingLater()) {
            clickController.complete(handledException);
        }
    }

    private boolean canClick(@NotNull UUID clickerUuid) {
        if (this.spamPreventionDuration != 0L) {
            LocalTime spamming = (LocalTime)this.spamPrevention.getIfPresent((Object)clickerUuid);
            if (spamming != null) {
                return false;
            }
            this.spamPrevention.put((Object)clickerUuid, (Object)LocalTime.now());
        }
        return !this.isProcessing;
    }
}

