/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.gui.builder;

import com.artillexstudios.axvaults.libs.gui.BaseGui;
import com.artillexstudios.axvaults.libs.gui.click.handler.ClickHandler;
import com.artillexstudios.axvaults.libs.gui.component.GuiComponent;
import com.artillexstudios.axvaults.libs.gui.component.functional.FunctionalGuiComponentBuilder;
import com.artillexstudios.axvaults.libs.gui.component.functional.SimpleFunctionalGuiComponent;
import com.artillexstudios.axvaults.libs.gui.component.renderer.GuiComponentRenderer;
import com.artillexstudios.axvaults.libs.gui.container.type.GuiContainerType;
import com.artillexstudios.axvaults.libs.gui.exception.TriumphGuiException;
import com.artillexstudios.axvaults.libs.gui.settings.GuiSettings;
import com.artillexstudios.axvaults.libs.kyori.adventure.text.Component;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class BaseGuiBuilder<B extends BaseGuiBuilder<B, P, G, I>, P, G extends BaseGui<P>, I> {
    private final GuiSettings<P, I, ?> guiSettings;
    private final GuiContainerType containerType;
    private final List<GuiComponent<P, I>> components = new ArrayList<GuiComponent<P, I>>();
    private ClickHandler<P> clickHandler = null;
    private GuiComponentRenderer<P, I> componentRenderer = null;
    private Component title = null;
    private long spamPreventionDuration = -1L;

    public BaseGuiBuilder(GuiSettings<P, I, ?> guiSettings, @NotNull GuiContainerType containerType) {
        this.guiSettings = guiSettings;
        this.containerType = containerType;
    }

    @Contract(value="_ -> this")
    @NotNull
    public B title(@NotNull Component title) {
        this.title = title;
        return (B)this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public B clickHandler(@NotNull ClickHandler<P> clickHandler) {
        this.clickHandler = clickHandler;
        return (B)this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public B componentRenderer(@NotNull GuiComponentRenderer<P, I> componentRenderer) {
        this.componentRenderer = componentRenderer;
        return (B)this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public B spamPreventionDuration(long spamPreventionDuration) {
        if (spamPreventionDuration < 0L) {
            throw new TriumphGuiException("Spam prevention duration cannot be negative!");
        }
        this.spamPreventionDuration = spamPreventionDuration;
        return (B)this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public B component(@NotNull FunctionalGuiComponentBuilder<P, I> builder) {
        SimpleFunctionalGuiComponent componentRenderer = new SimpleFunctionalGuiComponent();
        builder.accept(componentRenderer);
        this.components.add(componentRenderer.asGuiComponent());
        return (B)this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public B component(@NotNull GuiComponent<P, I> component) {
        this.components.add(component);
        return (B)this;
    }

    public abstract G build();

    @NotNull
    protected GuiContainerType getContainerType() {
        return this.containerType;
    }

    @NotNull
    protected List<GuiComponent<P, I>> getComponents() {
        return this.components;
    }

    @NotNull
    protected ClickHandler<P> getClickHandler() {
        if (this.clickHandler == null) {
            return this.guiSettings.getClickHandler();
        }
        return this.clickHandler;
    }

    @NotNull
    protected GuiComponentRenderer<P, I> getComponentRenderer() {
        if (this.componentRenderer == null) {
            return this.guiSettings.getComponentRenderer();
        }
        return this.componentRenderer;
    }

    @NotNull
    protected Component getTitle() {
        if (this.title == null) {
            throw new TriumphGuiException("Cannot create GUI with empty title!");
        }
        return this.title;
    }

    protected long getSpamPreventionDuration() {
        if (this.spamPreventionDuration < 0L) {
            return this.guiSettings.getSpamPreventionDuration();
        }
        return this.spamPreventionDuration;
    }
}

