/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.axapi.utils;

import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;

public class Cooldown<T> {
    private final Object2LongArrayMap<T> cooldowns = new Object2LongArrayMap();
    private long minCooldown = Long.MAX_VALUE;
    private long lastCheck = 0L;

    public void addCooldown(T key, long time) {
        this.doHouseKeeping();
        this.minCooldown = Math.min(this.minCooldown, time);
        this.cooldowns.put(key, System.currentTimeMillis() + time);
    }

    public long getRemaining(T key) {
        this.doHouseKeeping();
        return this.cooldowns.getOrDefault(key, System.currentTimeMillis()) - System.currentTimeMillis();
    }

    public long getRemainingAsSeconds(T key) {
        this.doHouseKeeping();
        return (this.cooldowns.getOrDefault(key, System.currentTimeMillis()) - System.currentTimeMillis()) / 1000L;
    }

    public boolean hasCooldown(T key) {
        this.doHouseKeeping();
        return this.cooldowns.containsKey(key);
    }

    public void clear() {
        this.cooldowns.clear();
    }

    public void remove(T key) {
        this.doHouseKeeping();
        this.cooldowns.remove(key);
    }

    private void doHouseKeeping() {
        if (System.currentTimeMillis() - this.lastCheck < this.minCooldown) {
            return;
        }
        ObjectIterator iterator = this.cooldowns.object2LongEntrySet().iterator();
        long time = this.lastCheck = System.currentTimeMillis();
        while (iterator.hasNext()) {
            Object2LongMap.Entry entry = (Object2LongMap.Entry)iterator.next();
            if (time < entry.getLongValue()) continue;
            iterator.remove();
        }
    }
}

