/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.axapi.utils;

import com.artillexstudios.axvaults.libs.axapi.nms.NMSHandlers;
import com.artillexstudios.axvaults.libs.kyori.adventure.text.Component;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.bukkit.entity.Player;

public interface BossBar {
    public static BossBar create(Component title) {
        return NMSHandlers.getNmsHandler().newBossBar(title, 1.0f, Color.PINK, Style.PROGRESS, new Flag[0]);
    }

    public static BossBar create(Component title, float progress) {
        return NMSHandlers.getNmsHandler().newBossBar(title, progress, Color.PINK, Style.PROGRESS, new Flag[0]);
    }

    public static BossBar create(Component title, float progress, Color color) {
        return NMSHandlers.getNmsHandler().newBossBar(title, progress, color, Style.PROGRESS, new Flag[0]);
    }

    public static BossBar create(Component title, float progress, Color color, Style style) {
        return NMSHandlers.getNmsHandler().newBossBar(title, progress, color, style, new Flag[0]);
    }

    public static BossBar create(Component title, float progress, Color color, Style style, Flag ... flags) {
        return NMSHandlers.getNmsHandler().newBossBar(title, progress, color, style, flags);
    }

    public void show(Player var1);

    public void hide(Player var1);

    public void setStyle(Style var1);

    public void setColor(Color var1);

    public void addFlags(Flag ... var1);

    public void removeFlags(Flag ... var1);

    public Set<Flag> getFlags();

    public Component getTitle();

    public void setTitle(Component var1);

    public float getProgress();

    public void setProgress(float var1);

    public void remove();

    public static enum Flag {
        DARKEN_SCREEN("darken_screen"),
        PLAY_BOSS_MUSIC("play_boss_music"),
        CREATE_WORLD_FOG("create_world_fog");

        private final String internalName;

        private Flag(String internalName) {
            this.internalName = internalName;
        }

        public String getInternalName() {
            return this.internalName;
        }
    }

    public static enum Color {
        PINK("pink"),
        BLUE("blue"),
        RED("red"),
        GREEN("green"),
        YELLOW("yellow"),
        PURPLE("purple"),
        WHITE("white");

        private final String internalName;

        private Color(String internalName) {
            this.internalName = internalName;
        }

        public static Style parse(String style) {
            return Style.valueOf(style.toLowerCase(Locale.ENGLISH));
        }

        public String getInternalName() {
            return this.internalName;
        }
    }

    public static enum Style {
        PROGRESS(Arrays.asList("progress", "solid"), "progress"),
        NOTCHED_6(Arrays.asList("notched_6", "segmented_6"), "notched_6"),
        NOTCHED_10(Arrays.asList("notched_10", "segmented_10"), "notched_10"),
        NOTCHED_12(Arrays.asList("notched_12", "segmented_12"), "notched_12"),
        NOTCHED_20(Arrays.asList("notched_20", "segmented_20"), "notched_20");

        private static final HashMap<List<String>, Style> STYLES;
        private final List<String> styleNames;
        private final String internalName;

        private Style(List<String> styleNames, String internalName) {
            this.styleNames = styleNames;
            this.internalName = internalName;
        }

        public static Style parse(String style) {
            for (Map.Entry<List<String>, Style> listStyleEntry : STYLES.entrySet()) {
                List<String> names = listStyleEntry.getKey();
                for (String name : names) {
                    if (!name.equalsIgnoreCase(style)) continue;
                    return listStyleEntry.getValue();
                }
            }
            return null;
        }

        public String getInternalName() {
            return this.internalName;
        }

        static {
            STYLES = new HashMap();
            for (Style value : Style.values()) {
                STYLES.put(value.styleNames, value);
            }
        }
    }
}

