/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.axapi.serializers.impl;

import com.artillexstudios.axvaults.libs.axapi.items.WrappedItemStack;
import com.artillexstudios.axvaults.libs.axapi.nms.NMSHandlers;
import com.artillexstudios.axvaults.libs.axapi.serializers.Serializer;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ItemArraySerializer
implements Serializer<ItemStack[], byte[]> {
    private static final ItemStack AIR = new ItemStack(Material.AIR);

    @Override
    public byte[] serialize(ItemStack[] value) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ByteArrayDataOutput outputStream = ByteStreams.newDataOutput((ByteArrayOutputStream)stream);
        outputStream.writeInt(value.length);
        for (ItemStack item : value) {
            if (item == null || item.getType().isAir()) {
                outputStream.writeShort(0);
                continue;
            }
            byte[] serialized = WrappedItemStack.wrap(item).serialize();
            outputStream.writeShort(serialized.length);
            outputStream.write(serialized);
        }
        return outputStream.toByteArray();
    }

    @Override
    public ItemStack[] deserialize(byte[] value) {
        ByteArrayDataInput input = ByteStreams.newDataInput((byte[])value);
        int length = input.readInt();
        ItemStack[] items = new ItemStack[length];
        for (int i = 0; i < length; ++i) {
            short size = input.readShort();
            if (size > 0) {
                byte[] read = new byte[size];
                input.readFully(read);
                items[i] = NMSHandlers.getNmsHandler().wrapItem(read).toBukkit();
                continue;
            }
            items[i] = AIR.clone();
        }
        return items;
    }
}

