/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.axapi.packetentity.tracker;

import com.artillexstudios.axvaults.libs.axapi.nms.NMSHandlers;
import com.artillexstudios.axvaults.libs.axapi.packetentity.PacketEntity;
import com.artillexstudios.axvaults.libs.axapi.reflection.FastFieldAccessor;
import com.artillexstudios.axvaults.libs.axapi.utils.Version;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.fastutil.objects.ReferenceSets;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public final class EntityTracker {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    private final Int2ObjectMap<TrackedEntity> entityMap = new Int2ObjectOpenHashMap();
    private final FastFieldAccessor accessor;

    public EntityTracker() {
        this.accessor = FastFieldAccessor.forClassField(String.format("com.artillexstudios.axvaults.libs.axapi.nms.%s.entity.PacketEntity", Version.getServerVersion().nmsVersion), "tracker");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PacketEntity getById(int id) {
        this.readLock.lock();
        try {
            TrackedEntity entity = (TrackedEntity)this.entityMap.get(id);
            PacketEntity packetEntity = entity == null ? null : entity.entity;
            return packetEntity;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void addEntity(PacketEntity entity) {
        TrackedEntity trackedEntity = new TrackedEntity(entity);
        this.accessor.set(entity, trackedEntity);
        this.writeLock.lock();
        try {
            this.entityMap.put(entity.id(), (Object)trackedEntity);
            trackedEntity.updateTracking(trackedEntity.getPlayersInTrackingRange());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeEntity(PacketEntity entity) {
        this.writeLock.lock();
        try {
            TrackedEntity trackedEntity = (TrackedEntity)this.entityMap.remove(entity.id());
            if (trackedEntity != null) {
                trackedEntity.broadcastRemove();
            }
            this.accessor.set(entity, null);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void untrackFor(Player player) {
        this.readLock.lock();
        try {
            for (Int2ObjectMap.Entry value : this.entityMap.int2ObjectEntrySet()) {
                TrackedEntity tracker = (TrackedEntity)value.getValue();
                tracker.untrack(player);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void process() {
        this.readLock.lock();
        try {
            for (TrackedEntity entity : this.entityMap.values()) {
                entity.updateTracking(entity.getPlayersInTrackingRange());
                entity.entity.sendChanges();
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public static class TrackedEntity {
        public final Set<Player> seenBy = ReferenceSets.synchronize((ReferenceSet)new ReferenceOpenHashSet());
        private final PacketEntity entity;
        private List<Player> lastTrackerCandidates;

        public TrackedEntity(PacketEntity entity) {
            this.entity = entity;
        }

        public void updateTracking(List<Player> newTrackerCandidates) {
            List<Player> oldTrackerCandidates = this.lastTrackerCandidates;
            this.lastTrackerCandidates = newTrackerCandidates;
            Location location = new Location(this.entity.location().getWorld(), 0.0, 0.0, 0.0);
            if (newTrackerCandidates != null) {
                for (Player raw : newTrackerCandidates) {
                    this.updatePlayer(raw, raw.getLocation(location));
                }
            }
            if (oldTrackerCandidates != null && oldTrackerCandidates.equals(newTrackerCandidates)) {
                return;
            }
            for (Player player : this.seenBy) {
                if (newTrackerCandidates != null && newTrackerCandidates.contains(player)) continue;
                this.updatePlayer(player, player.getLocation(location));
            }
        }

        public void updatePlayer(Player player, Location location) {
            boolean flag;
            double dz;
            double dx = location.getX() - this.entity.location().getX();
            double d1 = dx * dx + (dz = location.getZ() - this.entity.location().getZ()) * dz;
            boolean bl = flag = d1 <= 1024.0;
            if (flag && !this.entity.canSee(player)) {
                flag = false;
            }
            if (flag) {
                if (this.seenBy.add(player)) {
                    this.entity.addPairing(player);
                }
            } else if (this.seenBy.remove(player)) {
                this.entity.removePairing(player);
            }
        }

        public void untrack(Player player) {
            if (!this.seenBy.remove(player)) {
                return;
            }
            this.entity.removePairing(player);
        }

        public List<Player> getPlayersInTrackingRange() {
            return this.entity.location().getWorld().getPlayers();
        }

        public void broadcast(Object packet) {
            for (Player player : this.seenBy) {
                NMSHandlers.getNmsHandler().sendPacket(player, packet);
            }
        }

        public void broadcastRemove() {
            for (Player player : this.seenBy) {
                this.entity.removePairing(player);
            }
        }
    }
}

