/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.axapi.nms.v1_20_R2.packet;

import com.artillexstudios.axvaults.libs.axapi.AxPlugin;
import com.artillexstudios.axvaults.libs.axapi.events.PacketEntityInteractEvent;
import com.artillexstudios.axvaults.libs.axapi.gui.SignInput;
import com.artillexstudios.axvaults.libs.axapi.items.PacketItemModifier;
import com.artillexstudios.axvaults.libs.axapi.nms.v1_20_R2.items.WrappedItemStack;
import com.artillexstudios.axvaults.libs.axapi.packetentity.PacketEntity;
import com.artillexstudios.axvaults.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axvaults.libs.axapi.utils.ComponentSerializer;
import com.artillexstudios.axvaults.libs.axapi.utils.FeatureFlags;
import com.artillexstudios.axvaults.libs.kyori.adventure.text.Component;
import com.mojang.datafixers.util.Pair;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.PacketPlayInSetCreativeSlot;
import net.minecraft.network.protocol.game.PacketPlayInUpdateSign;
import net.minecraft.network.protocol.game.PacketPlayInUseEntity;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.item.ItemStack;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftLocation;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketListener
extends ChannelDuplexHandler {
    private static final Logger log = LoggerFactory.getLogger(PacketListener.class);
    private final Player player;

    public PacketListener(Player player) {
        this.player = player;
    }

    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) throws Exception {
        if (msg instanceof PacketPlayInUseEntity) {
            PacketPlayInUseEntity packet = (PacketPlayInUseEntity)msg;
            if (AxPlugin.tracker == null) {
                super.channelRead(ctx, msg);
                return;
            }
            PacketDataSerializer byteBuf = new PacketDataSerializer(Unpooled.buffer());
            packet.a(byteBuf);
            int entityId = byteBuf.m();
            int actionType = byteBuf.m();
            EnumHand hand = null;
            Vector vector = null;
            boolean attack = false;
            if (actionType == 0) {
                int interactionHand = byteBuf.m();
                hand = interactionHand == 0 ? EnumHand.a : EnumHand.b;
            } else if (actionType == 1) {
                attack = true;
            } else {
                float x = byteBuf.readFloat();
                float y = byteBuf.readFloat();
                float z = byteBuf.readFloat();
                vector = new Vector(x, y, z);
                int interactionHand = byteBuf.m();
                hand = interactionHand == 0 ? EnumHand.a : EnumHand.b;
            }
            byteBuf.release();
            PacketEntity entity = AxPlugin.tracker.getById(entityId);
            if (entity != null) {
                PacketEntityInteractEvent event = new PacketEntityInteractEvent(this.player, entity, attack, vector, hand == EnumHand.a ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND);
                Bukkit.getPluginManager().callEvent((Event)event);
            }
        } else {
            if (msg instanceof PacketPlayInUpdateSign) {
                PacketPlayInUpdateSign updatePacket = (PacketPlayInUpdateSign)msg;
                SignInput signInput = SignInput.remove(this.player);
                if (signInput == null) {
                    super.channelRead(ctx, msg);
                    return;
                }
                signInput.getListener().accept(this.player, ComponentSerializer.INSTANCE.asAdventureFromJson(Arrays.asList(updatePacket.e())).toArray(new Component[0]));
                Scheduler.get().runAt(signInput.getLocation(), task -> {
                    CraftBlockData data = (CraftBlockData)signInput.getLocation().getBlock().getType().createBlockData();
                    BlockPosition pos = CraftLocation.toBlockPosition((Location)signInput.getLocation());
                    EntityPlayer serverPlayer = ((CraftPlayer)this.player).getHandle();
                    serverPlayer.c.b((Packet)new PacketPlayOutBlockChange(pos, data.getState()));
                });
                return;
            }
            if (msg instanceof PacketPlayInSetCreativeSlot) {
                PacketPlayInSetCreativeSlot packet = (PacketPlayInSetCreativeSlot)msg;
                ItemStack item = packet.d();
                if (PacketItemModifier.isListening()) {
                    PacketItemModifier.restore(new WrappedItemStack(item));
                }
            }
        }
        super.channelRead(ctx, msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof PacketPlayOutSetSlot) {
            PacketPlayOutSetSlot packet = (PacketPlayOutSetSlot)msg;
            if (PacketItemModifier.isListening()) {
                PacketItemModifier.callModify(new WrappedItemStack(packet.e()), this.player, PacketItemModifier.Context.SET_SLOT);
            }
            super.write(ctx, (Object)packet, promise);
        } else if (msg instanceof PacketPlayOutWindowItems) {
            PacketPlayOutWindowItems packet = (PacketPlayOutWindowItems)msg;
            if (PacketItemModifier.isListening()) {
                PacketItemModifier.callModify(new WrappedItemStack(packet.e()), this.player, PacketItemModifier.Context.SET_CONTENTS);
                for (ItemStack item : packet.d()) {
                    PacketItemModifier.callModify(new WrappedItemStack(item), this.player, PacketItemModifier.Context.SET_CONTENTS);
                }
            }
            super.write(ctx, (Object)packet, promise);
        } else if (msg instanceof PacketPlayOutEntityEquipment) {
            PacketPlayOutEntityEquipment packet = (PacketPlayOutEntityEquipment)msg;
            if (PacketItemModifier.isListening()) {
                ArrayList<Pair> items = new ArrayList<Pair>();
                for (Pair slot : packet.d()) {
                    ItemStack itemStack = ((ItemStack)slot.getSecond()).p();
                    PacketItemModifier.callModify(new WrappedItemStack(itemStack), this.player, PacketItemModifier.Context.EQUIPMENT);
                    items.add(Pair.of((Object)((EnumItemSlot)slot.getFirst()), (Object)itemStack));
                }
                PacketPlayOutEntityEquipment newEquipmentPacket = new PacketPlayOutEntityEquipment(packet.a(), items);
                super.write(ctx, (Object)newEquipmentPacket, promise);
            } else {
                super.write(ctx, msg, promise);
            }
        } else if (msg instanceof PacketPlayOutEntityMetadata) {
            PacketPlayOutEntityMetadata packet = (PacketPlayOutEntityMetadata)msg;
            List packedItems = packet.d();
            if (PacketItemModifier.isListening()) {
                for (DataWatcher.b packedItem : packedItems) {
                    Object object = packedItem.c();
                    if (!(object instanceof ItemStack)) continue;
                    ItemStack stack = (ItemStack)object;
                    WrappedItemStack wrapped = new WrappedItemStack(stack);
                    PacketItemModifier.callModify(wrapped, this.player, PacketItemModifier.Context.DROPPED_ITEM);
                }
            }
            super.write(ctx, msg, promise);
        } else if (msg instanceof ClientboundBundlePacket) {
            ClientboundBundlePacket packet = (ClientboundBundlePacket)msg;
            if (PacketItemModifier.isListening()) {
                for (Packet subPacket : packet.a()) {
                    if (!(subPacket instanceof PacketPlayOutEntityMetadata)) continue;
                    PacketPlayOutEntityMetadata metaPacket = (PacketPlayOutEntityMetadata)subPacket;
                    List packedItems = metaPacket.d();
                    for (DataWatcher.b packedItem : packedItems) {
                        Object object = packedItem.c();
                        if (!(object instanceof ItemStack)) continue;
                        ItemStack stack = (ItemStack)object;
                        WrappedItemStack wrapped = new WrappedItemStack(stack);
                        PacketItemModifier.callModify(wrapped, this.player, PacketItemModifier.Context.DROPPED_ITEM);
                    }
                }
            }
            super.write(ctx, msg, promise);
        } else {
            super.write(ctx, msg, promise);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (FeatureFlags.DEBUG.get().booleanValue()) {
            log.error("An unhandled exception occurred on ctx {}!", (Object)ctx, (Object)cause);
        }
        super.exceptionCaught(ctx, cause);
    }
}

