/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.axapi.nms.v1_19_R3;

import com.artillexstudios.axvaults.libs.axapi.gui.SignInput;
import com.artillexstudios.axvaults.libs.axapi.nms.v1_19_R3.BlockSetterImpl;
import com.artillexstudios.axvaults.libs.axapi.nms.v1_19_R3.ItemStackSerializer;
import com.artillexstudios.axvaults.libs.axapi.nms.v1_19_R3.ParallelBlockSetterImpl;
import com.artillexstudios.axvaults.libs.axapi.nms.v1_19_R3.entity.PacketEntity;
import com.artillexstudios.axvaults.libs.axapi.nms.v1_19_R3.items.WrappedItemStack;
import com.artillexstudios.axvaults.libs.axapi.nms.v1_19_R3.items.data.DataComponentImpl;
import com.artillexstudios.axvaults.libs.axapi.nms.v1_19_R3.items.nbt.CompoundTag;
import com.artillexstudios.axvaults.libs.axapi.nms.v1_19_R3.loot.LootTable;
import com.artillexstudios.axvaults.libs.axapi.nms.v1_19_R3.packet.PacketListener;
import com.artillexstudios.axvaults.libs.axapi.nms.v1_19_R3.utils.ActionBar;
import com.artillexstudios.axvaults.libs.axapi.nms.v1_19_R3.utils.BossBar;
import com.artillexstudios.axvaults.libs.axapi.nms.v1_19_R3.utils.DebugMarker;
import com.artillexstudios.axvaults.libs.axapi.nms.v1_19_R3.utils.Title;
import com.artillexstudios.axvaults.libs.axapi.selection.BlockSetter;
import com.artillexstudios.axvaults.libs.axapi.selection.ParallelBlockSetter;
import com.artillexstudios.axvaults.libs.axapi.serializers.Serializer;
import com.artillexstudios.axvaults.libs.axapi.utils.BossBar;
import com.artillexstudios.axvaults.libs.axapi.utils.ComponentSerializer;
import com.artillexstudios.axvaults.libs.axapi.utils.Pair;
import com.artillexstudios.axvaults.libs.kyori.adventure.key.Key;
import com.artillexstudios.axvaults.libs.kyori.adventure.text.Component;
import com.artillexstudios.axvaults.libs.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutOpenSignEditor;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftContainer;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftLocation;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftMagicNumbers;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class NMSHandler
implements com.artillexstudios.axvaults.libs.axapi.nms.NMSHandler {
    private final String AXAPI_HANDLER;
    private Field channelField;
    private Field connectionField;
    private AtomicInteger entityCounter;

    public NMSHandler(JavaPlugin plugin) {
        this.AXAPI_HANDLER = "axapi_handler_" + plugin.getName().toLowerCase(Locale.ENGLISH);
        try {
            this.connectionField = Class.forName("net.minecraft.server.network.PlayerConnection").getDeclaredField("h");
            this.connectionField.setAccessible(true);
            this.channelField = Class.forName("net.minecraft.network.NetworkManager").getDeclaredField("m");
            this.channelField.setAccessible(true);
            Field entityIdField = Entity.class.getDeclaredField("d");
            entityIdField.setAccessible(true);
            this.entityCounter = (AtomicInteger)entityIdField.get(null);
        }
        catch (Exception exception) {
            log.error("An exception occurred while initializing NMSHandler!", (Throwable)exception);
        }
    }

    @Override
    public Serializer<Object, Component> componentSerializer() {
        return new Serializer<Object, Component>(){

            @Override
            public Component serialize(Object object) {
                if (!(object instanceof IChatBaseComponent)) {
                    throw new IllegalStateException("Can only serialize component!");
                }
                IChatBaseComponent component = (IChatBaseComponent)object;
                String gsonText = IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)component);
                return GsonComponentSerializer.gson().deserialize(gsonText);
            }

            @Override
            public Object deserialize(Component value) {
                return IChatBaseComponent.ChatSerializer.a((JsonElement)GsonComponentSerializer.gson().serializer().toJsonTree(value));
            }
        };
    }

    @Override
    public void injectPlayer(Player player) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        Channel channel = this.getChannel(this.getConnection(serverPlayer.b));
        if (!channel.pipeline().names().contains("packet_handler")) {
            return;
        }
        if (channel.pipeline().names().contains(this.AXAPI_HANDLER)) {
            return;
        }
        channel.eventLoop().submit(() -> channel.pipeline().addBefore("packet_handler", this.AXAPI_HANDLER, (ChannelHandler)new PacketListener(player)));
    }

    @Override
    public void uninjectPlayer(Player player) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        Channel channel = this.getChannel(this.getConnection(serverPlayer.b));
        channel.eventLoop().submit(() -> {
            if (channel.pipeline().get(this.AXAPI_HANDLER) != null) {
                channel.pipeline().remove(this.AXAPI_HANDLER);
            }
        });
    }

    @Override
    public int getProtocolVersionId(Player player) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        return serverPlayer.b.h.protocolVersion;
    }

    @Override
    public com.artillexstudios.axvaults.libs.axapi.packetentity.PacketEntity createEntity(EntityType entityType, Location location) {
        return new PacketEntity(entityType, location);
    }

    @Override
    public BlockSetter newSetter(World world) {
        return new BlockSetterImpl(world);
    }

    @Override
    public com.artillexstudios.axvaults.libs.axapi.utils.ActionBar newActionBar(Component content) {
        return new ActionBar(content);
    }

    @Override
    public com.artillexstudios.axvaults.libs.axapi.utils.Title newTitle(Component title, Component subtitle, int fadeIn, int stay, int fadeOut) {
        return new Title(title, subtitle, fadeIn, stay, fadeOut);
    }

    @Override
    public com.artillexstudios.axvaults.libs.axapi.utils.BossBar newBossBar(Component title, float progress, BossBar.Color color, BossBar.Style style, BossBar.Flag ... flags) {
        return new BossBar(title, progress, color, style, flags);
    }

    @Override
    public com.artillexstudios.axvaults.libs.axapi.items.nbt.CompoundTag newTag() {
        return new CompoundTag(new NBTTagCompound());
    }

    @Override
    public com.artillexstudios.axvaults.libs.axapi.items.WrappedItemStack wrapItem(ItemStack itemStack) {
        return new WrappedItemStack(itemStack);
    }

    @Override
    public com.artillexstudios.axvaults.libs.axapi.items.WrappedItemStack wrapItem(String snbt) {
        try {
            NBTTagCompound tag = MojangsonParser.a((String)snbt);
            int dataVersion = tag.h("DataVersion");
            NBTTagCompound converted = (NBTTagCompound)MinecraftServer.getServer().L.update(DataConverterTypes.m, new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)tag), dataVersion, CraftMagicNumbers.INSTANCE.getDataVersion()).getValue();
            net.minecraft.world.item.ItemStack item = net.minecraft.world.item.ItemStack.a((NBTTagCompound)converted);
            return new WrappedItemStack(item);
        }
        catch (CommandSyntaxException exception) {
            log.error("An error occurred while parsing item from SNBT!", (Throwable)exception);
            return null;
        }
    }

    @Override
    public com.artillexstudios.axvaults.libs.axapi.items.WrappedItemStack wrapItem(byte[] bytes) {
        return this.wrapItem(ItemStackSerializer.INSTANCE.deserializeFromBytes(bytes));
    }

    @Override
    public void openSignInput(SignInput signInput) {
        EntityPlayer player = ((CraftPlayer)signInput.getPlayer()).getHandle();
        BlockPosition pos = CraftLocation.toBlockPosition((Location)signInput.getLocation());
        player.b.a((Packet)new PacketPlayOutBlockChange(pos, ((CraftBlockData)Material.OAK_SIGN.createBlockData()).getState()));
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        buf.a(pos);
        buf.a((Registry)BuiltInRegistries.l, (Object)TileEntityTypes.h);
        NBTTagCompound tag = new NBTTagCompound();
        tag.a("x", pos.u());
        tag.a("y", pos.v());
        tag.a("z", pos.w());
        tag.a("id", "minecraft:oak_sign");
        if (!tag.e("front_text")) {
            tag.a("front_text", (NBTBase)new NBTTagCompound());
        }
        NBTTagCompound sideTag = tag.p("front_text");
        if (!tag.e("messages")) {
            sideTag.a("messages", (NBTBase)new NBTTagList());
        }
        NBTTagList messagesNbt = sideTag.c("messages", 8);
        for (int i = 0; i < 4; ++i) {
            String gson = this.toGson(i > signInput.getLines().length ? Component.empty() : signInput.getLines()[i]);
            messagesNbt.c(i, (NBTBase)NBTTagString.a((String)gson));
        }
        buf.a(tag);
        PacketPlayOutTileEntityData clientboundBlockEntityDataPacket = new PacketPlayOutTileEntityData(buf);
        PacketPlayOutOpenSignEditor openSignEditorPacket = new PacketPlayOutOpenSignEditor(pos);
        player.b.a((Packet)clientboundBlockEntityDataPacket);
        player.b.a((Packet)openSignEditorPacket);
        buf.release();
    }

    @Override
    public void setTitle(Inventory inventory, Component title) {
        IChatBaseComponent nmsTitle = (IChatBaseComponent)ComponentSerializer.INSTANCE.toVanilla(title);
        for (HumanEntity viewer : inventory.getViewers()) {
            CraftPlayer craftPlayer = (CraftPlayer)viewer;
            EntityPlayer serverPlayer = craftPlayer.getHandle();
            int containerId = serverPlayer.bP.j;
            Containers windowType = CraftContainer.getNotchInventoryType((Inventory)inventory);
            serverPlayer.b.a((Packet)new PacketPlayOutOpenWindow(containerId, windowType, nmsTitle));
            craftPlayer.updateInventory();
        }
    }

    @Override
    public com.artillexstudios.axvaults.libs.axapi.items.component.DataComponentImpl dataComponents() {
        return new DataComponentImpl();
    }

    @Override
    public OfflinePlayer getCachedOfflinePlayer(String name) {
        GameProfile profile;
        Player result = Bukkit.getPlayerExact((String)name);
        if (result == null && (profile = MinecraftServer.getServer().ap().getProfileIfCached(name)) != null) {
            result = ((CraftServer)Bukkit.getServer()).getOfflinePlayer(profile);
        }
        return result;
    }

    @Override
    public void sendPacket(Player player, Object packet) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        EntityPlayer serverPlayer = craftPlayer.getHandle();
        serverPlayer.b.a((Packet)packet);
    }

    @Override
    public ParallelBlockSetter newParallelSetter(World world) {
        return new ParallelBlockSetterImpl(world);
    }

    @Override
    public int nextEntityId() {
        return this.entityCounter.incrementAndGet();
    }

    @Override
    public Pair<String, String> textures(Player player) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        EntityPlayer serverPlayer = craftPlayer.getHandle();
        GameProfile profile = serverPlayer.fI();
        Optional property = profile.getProperties().get((Object)"textures").stream().findFirst();
        return property.map(value -> Pair.of(value.getValue(), value.getSignature())).orElse(null);
    }

    @Override
    public void sendMessage(Player player, Component message) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        EntityPlayer serverPlayer = craftPlayer.getHandle();
        serverPlayer.b.a((Packet)new ClientboundSystemChatPacket((IChatBaseComponent)ComponentSerializer.INSTANCE.toVanilla(message), false));
    }

    @Override
    public com.artillexstudios.axvaults.libs.axapi.utils.DebugMarker marker(Color color, String message, int duration, int transparency, Location location) {
        return new DebugMarker(color, message, duration, transparency, location);
    }

    @Override
    public double getBase(Player player, Attribute attribute) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        return craftPlayer.getAttribute(attribute).getDefaultValue();
    }

    @Override
    public Player dummyPlayer() {
        return new EntityPlayer(MinecraftServer.getServer(), ((CraftWorld)Bukkit.getWorlds().get(0)).getHandle(), new GameProfile(UUID.randomUUID(), "dummy")).getBukkitEntity();
    }

    @Override
    public com.artillexstudios.axvaults.libs.axapi.loot.LootTable lootTable(Key key) {
        return new LootTable(key);
    }

    public String toGson(Component component) {
        return (String)GsonComponentSerializer.gson().serialize(component);
    }

    private Channel getChannel(NetworkManager connection) {
        try {
            return (Channel)this.channelField.get(connection);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private NetworkManager getConnection(PlayerConnection serverGamePacketListener) {
        try {
            return (NetworkManager)this.connectionField.get(serverGamePacketListener);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

