/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.axapi.nms.v1_18_R2.items.data;

import com.artillexstudios.axvaults.libs.axapi.items.component.DataComponent;
import com.artillexstudios.axvaults.libs.axapi.items.component.DyedColor;
import com.artillexstudios.axvaults.libs.axapi.items.component.ItemEnchantments;
import com.artillexstudios.axvaults.libs.axapi.items.component.ItemLore;
import com.artillexstudios.axvaults.libs.axapi.items.component.ProfileProperties;
import com.artillexstudios.axvaults.libs.axapi.items.component.Rarity;
import com.artillexstudios.axvaults.libs.axapi.items.component.Unbreakable;
import com.artillexstudios.axvaults.libs.axapi.items.component.Unit;
import com.artillexstudios.axvaults.libs.axapi.nms.v1_18_R2.items.nbt.CompoundTag;
import com.artillexstudios.axvaults.libs.axapi.utils.ComponentSerializer;
import com.artillexstudios.axvaults.libs.kyori.adventure.text.Component;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemEnchantedBook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.WeightedRandomEnchant;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_18_R2.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_18_R2.potion.CraftPotionUtil;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftNamespacedKey;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.Nullable;

public class DataComponentImpl
implements com.artillexstudios.axvaults.libs.axapi.items.component.DataComponentImpl {
    private static void addItemFlags(NBTTagCompound tag, ItemFlag ... itemFlags) {
        int flag = tag.b("HideFlags", 99) ? (int)tag.h("HideFlags") : 0;
        for (ItemFlag itemFlag : itemFlags) {
            flag = (byte)(flag | DataComponentImpl.getBitModifier(itemFlag));
        }
        tag.a("HideFlags", flag);
    }

    private static byte getBitModifier(ItemFlag hideFlag) {
        return (byte)(1 << hideFlag.ordinal());
    }

    private static void setDisplayTag(NBTTagCompound compoundTag, String key, @Nullable NBTBase value) {
        NBTTagCompound display = compoundTag.p("display");
        if (!compoundTag.e("display")) {
            compoundTag.a("display", (NBTBase)display);
        }
        display.r(key);
        if (value != null) {
            display.a(key, value);
        }
    }

    private static void removeItemFlags(NBTTagCompound tag, ItemFlag ... itemFlags) {
        int flag = tag.b("HideFlags", 99) ? (int)tag.h("HideFlags") : 0;
        for (ItemFlag itemFlag : itemFlags) {
            flag = (byte)(flag & (byte)(~DataComponentImpl.getBitModifier(itemFlag)));
        }
        tag.a("HideFlags", flag);
    }

    private static boolean hasItemFlag(NBTTagCompound tag, ItemFlag itemFlag) {
        byte flag = tag.b("HideFlags", 99) ? (byte)tag.h("HideFlags") : (byte)0;
        byte bitModifier = DataComponentImpl.getBitModifier(itemFlag);
        return (flag & bitModifier) == bitModifier;
    }

    private static NBTTagCompound getDisplayTag(NBTTagCompound compoundTag) {
        if (!compoundTag.e("display")) {
            return null;
        }
        return compoundTag.p("display");
    }

    private static org.bukkit.enchantments.Enchantment minecraftToBukkit(Enchantment minecraft) {
        Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
        IRegistry registry = IRegistry.V;
        org.bukkit.enchantments.Enchantment bukkit = (org.bukkit.enchantments.Enchantment)Registry.ENCHANTMENT.get(CraftNamespacedKey.fromMinecraft((MinecraftKey)((ResourceKey)registry.c((Object)minecraft).orElseThrow()).a()));
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit;
    }

    @Override
    public DataComponent<com.artillexstudios.axvaults.libs.axapi.items.nbt.CompoundTag> customData() {
        return new DataComponent<com.artillexstudios.axvaults.libs.axapi.items.nbt.CompoundTag>(){

            @Override
            public void apply(Object item, com.artillexstudios.axvaults.libs.axapi.items.nbt.CompoundTag compoundTag) {
                ItemStack itemStack = (ItemStack)item;
                itemStack.c((NBTTagCompound)compoundTag.getParent());
            }

            @Override
            public com.artillexstudios.axvaults.libs.axapi.items.nbt.CompoundTag get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                NBTTagCompound tag = itemStack.t();
                return new CompoundTag(tag == null ? new NBTTagCompound() : tag);
            }
        };
    }

    @Override
    public DataComponent<Integer> maxStackSize() {
        return new DataComponent<Integer>(){

            @Override
            public void apply(Object item, Integer integer) {
            }

            @Override
            public Integer get(Object item) {
                return 0;
            }
        };
    }

    @Override
    public DataComponent<Integer> maxDamage() {
        return new DataComponent<Integer>(){

            @Override
            public void apply(Object item, Integer integer) {
            }

            @Override
            public Integer get(Object item) {
                return 0;
            }
        };
    }

    @Override
    public DataComponent<Integer> damage() {
        return new DataComponent<Integer>(){

            @Override
            public void apply(Object item, Integer integer) {
                ItemStack itemStack = (ItemStack)item;
                if (integer == null || integer == 0) {
                    itemStack.b(0);
                    return;
                }
                itemStack.b(integer.intValue());
            }

            @Override
            public Integer get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                return itemStack.i();
            }
        };
    }

    @Override
    public DataComponent<Unbreakable> unbreakable() {
        return new DataComponent<Unbreakable>(){

            @Override
            public void apply(Object item, Unbreakable unbreakable) {
                ItemStack itemStack = (ItemStack)item;
                NBTTagCompound tag = itemStack.u();
                if (unbreakable == null) {
                    tag.r("Unbreakable");
                    return;
                }
                if (!unbreakable.showInTooltip()) {
                    DataComponentImpl.addItemFlags(tag, ItemFlag.HIDE_UNBREAKABLE);
                }
                tag.a("Unbreakable", true);
            }

            @Override
            public Unbreakable get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                NBTTagCompound tag = itemStack.t();
                if (tag == null || !tag.e("Unbreakable")) {
                    return null;
                }
                return new Unbreakable(!DataComponentImpl.hasItemFlag(tag, ItemFlag.HIDE_UNBREAKABLE));
            }
        };
    }

    @Override
    public DataComponent<Component> customName() {
        return new DataComponent<Component>(){

            @Override
            public void apply(Object item, Component component) {
                ItemStack itemStack = (ItemStack)item;
                NBTTagCompound tag = itemStack.u();
                if (component == null) {
                    DataComponentImpl.setDisplayTag(tag, "Name", null);
                    return;
                }
                DataComponentImpl.setDisplayTag(tag, "Name", (NBTBase)NBTTagString.a((String)ComponentSerializer.INSTANCE.toGson(component)));
            }

            @Override
            public Component get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                NBTTagCompound tag = itemStack.t();
                if (tag == null) {
                    return Component.empty();
                }
                NBTTagCompound display = DataComponentImpl.getDisplayTag(tag);
                if (display == null) {
                    return Component.empty();
                }
                if (!display.e("Name")) {
                    return Component.empty();
                }
                return ComponentSerializer.INSTANCE.fromGson(display.l("Name"));
            }
        };
    }

    @Override
    public DataComponent<Component> itemName() {
        return new DataComponent<Component>(){

            @Override
            public void apply(Object item, Component component) {
                ItemStack itemStack = (ItemStack)item;
                NBTTagCompound tag = itemStack.u();
                if (component == null) {
                    DataComponentImpl.setDisplayTag(tag, "Name", null);
                    return;
                }
                DataComponentImpl.setDisplayTag(tag, "Name", (NBTBase)NBTTagString.a((String)ComponentSerializer.INSTANCE.toGson(component)));
            }

            @Override
            public Component get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                NBTTagCompound tag = itemStack.t();
                if (tag == null) {
                    return Component.empty();
                }
                NBTTagCompound display = DataComponentImpl.getDisplayTag(tag);
                if (display == null) {
                    return Component.empty();
                }
                if (!display.e("Name")) {
                    return Component.empty();
                }
                return ComponentSerializer.INSTANCE.fromGson(display.l("Name"));
            }
        };
    }

    @Override
    public DataComponent<ItemLore> lore() {
        return new DataComponent<ItemLore>(){

            @Override
            public void apply(Object item, ItemLore itemLore) {
                ItemStack itemStack = (ItemStack)item;
                NBTTagCompound tag = itemStack.u();
                if (itemLore == null) {
                    DataComponentImpl.setDisplayTag(tag, "Lore", null);
                    return;
                }
                NBTTagList listTag = new NBTTagList();
                List<String> jsonLore = ComponentSerializer.INSTANCE.toGsonList(itemLore.lines());
                for (int i = 0; i < jsonLore.size(); ++i) {
                    listTag.add((Object)NBTTagString.a((String)jsonLore.get(i)));
                }
                DataComponentImpl.setDisplayTag(tag, "Lore", (NBTBase)listTag);
            }

            @Override
            public ItemLore get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                NBTTagCompound tag = itemStack.t();
                if (tag == null) {
                    return new ItemLore(List.of(), List.of());
                }
                NBTTagCompound display = DataComponentImpl.getDisplayTag(tag);
                if (display == null) {
                    return new ItemLore(List.of(), List.of());
                }
                if (!display.e("Lore")) {
                    return new ItemLore(List.of(), List.of());
                }
                NBTTagList list = display.c("Lore", 8);
                ArrayList<String> lore = new ArrayList<String>(list.size());
                for (int index = 0; index < list.size(); ++index) {
                    String line = list.j(index);
                    lore.add(line);
                }
                return new ItemLore(ComponentSerializer.INSTANCE.fromGsonList(lore));
            }
        };
    }

    @Override
    public DataComponent<Rarity> rarity() {
        return new DataComponent<Rarity>(){

            @Override
            public void apply(Object item, Rarity rarity) {
            }

            @Override
            public Rarity get(Object item) {
                return Rarity.COMMON;
            }
        };
    }

    @Override
    public DataComponent<ItemEnchantments> enchantments() {
        return new DataComponent<ItemEnchantments>(){

            @Override
            public void apply(Object item, ItemEnchantments itemEnchantments) {
                ItemStack itemStack = (ItemStack)item;
                NBTTagCompound tag = itemStack.u();
                if (itemEnchantments == null) {
                    tag.r("Enchantments");
                    return;
                }
                HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
                for (Map.Entry<org.bukkit.enchantments.Enchantment, Integer> entry : itemEnchantments.entrySet()) {
                    enchantments.put(CraftEnchantment.getRaw((org.bukkit.enchantments.Enchantment)entry.getKey()), entry.getValue());
                }
                EnchantmentManager.a(enchantments, (ItemStack)itemStack);
                if (!itemEnchantments.showInTooltip()) {
                    DataComponentImpl.addItemFlags(tag, ItemFlag.HIDE_ENCHANTS);
                }
            }

            @Override
            public ItemEnchantments get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                NBTTagCompound tag = itemStack.t();
                Map enchants = EnchantmentManager.a((ItemStack)itemStack);
                HashMap<org.bukkit.enchantments.Enchantment, Integer> enchantments = new HashMap<org.bukkit.enchantments.Enchantment, Integer>();
                for (Map.Entry entry : enchants.entrySet()) {
                    enchantments.put(DataComponentImpl.minecraftToBukkit((Enchantment)entry.getKey()), (Integer)entry.getValue());
                }
                return new ItemEnchantments(enchantments, tag == null ? true : !DataComponentImpl.hasItemFlag(tag, ItemFlag.HIDE_ENCHANTS));
            }
        };
    }

    @Override
    public DataComponent<Integer> customModelData() {
        return new DataComponent<Integer>(){

            @Override
            public void apply(Object item, Integer integer) {
                ItemStack itemStack = (ItemStack)item;
                NBTTagCompound tag = itemStack.u();
                if (integer == null || integer == 0) {
                    tag.r("CustomModelData");
                    return;
                }
                tag.a("CustomModelData", integer.intValue());
            }

            @Override
            public Integer get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                NBTTagCompound tag = itemStack.t();
                return tag == null ? 0 : tag.h("CustomModelData");
            }
        };
    }

    @Override
    public DataComponent<Unit> hideAdditionalTooltip() {
        return new DataComponent<Unit>(){

            @Override
            public void apply(Object item, Unit unit) {
                ItemStack itemStack = (ItemStack)item;
                NBTTagCompound tag = itemStack.u();
                if (unit == null) {
                    DataComponentImpl.removeItemFlags(tag, ItemFlag.HIDE_ATTRIBUTES);
                    return;
                }
                DataComponentImpl.addItemFlags(tag, ItemFlag.HIDE_ATTRIBUTES);
            }

            @Override
            public Unit get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                NBTTagCompound tag = itemStack.t();
                return tag == null ? null : (DataComponentImpl.hasItemFlag(tag, ItemFlag.HIDE_ATTRIBUTES) ? Unit.INSTANCE : null);
            }
        };
    }

    @Override
    public DataComponent<Unit> hideTooltip() {
        return new DataComponent<Unit>(){

            @Override
            public void apply(Object item, Unit unit) {
                ItemStack itemStack = (ItemStack)item;
                NBTTagCompound tag = itemStack.u();
                if (unit == null) {
                    DataComponentImpl.removeItemFlags(tag, ItemFlag.HIDE_ENCHANTS);
                    return;
                }
                DataComponentImpl.addItemFlags(tag, ItemFlag.HIDE_ENCHANTS);
            }

            @Override
            public Unit get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                NBTTagCompound tag = itemStack.t();
                return tag == null ? null : (DataComponentImpl.hasItemFlag(tag, ItemFlag.HIDE_ENCHANTS) ? Unit.INSTANCE : null);
            }
        };
    }

    @Override
    public DataComponent<Integer> repairCost() {
        return new DataComponent<Integer>(){

            @Override
            public void apply(Object item, Integer integer) {
                ItemStack itemStack = (ItemStack)item;
                if (integer == null) {
                    itemStack.c(0);
                    return;
                }
                itemStack.c(integer.intValue());
            }

            @Override
            public Integer get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                return itemStack.G();
            }
        };
    }

    @Override
    public DataComponent<Unit> creativeSlotLock() {
        return new DataComponent<Unit>(){

            @Override
            public void apply(Object item, Unit unit) {
            }

            @Override
            public Unit get(Object item) {
                return null;
            }
        };
    }

    @Override
    public DataComponent<Boolean> enchantmentGlintOverride() {
        return new DataComponent<Boolean>(){

            @Override
            public void apply(Object item, Boolean glint) {
                ItemStack itemStack = (ItemStack)item;
                NBTTagCompound tag = itemStack.u();
                if (glint == null) {
                    return;
                }
                DataComponentImpl.this.enchantments().apply(item, new ItemEnchantments(new HashMap<org.bukkit.enchantments.Enchantment, Integer>(Map.of(org.bukkit.enchantments.Enchantment.LOYALTY, 1)), true));
                DataComponentImpl.addItemFlags(tag, ItemFlag.HIDE_ENCHANTS);
            }

            @Override
            public Boolean get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                return true;
            }
        };
    }

    @Override
    public DataComponent<Unit> intangibleProjectile() {
        return new DataComponent<Unit>(){

            @Override
            public void apply(Object item, Unit unit) {
            }

            @Override
            public Unit get(Object item) {
                return null;
            }
        };
    }

    @Override
    public DataComponent<ItemEnchantments> storedEnchantments() {
        return new DataComponent<ItemEnchantments>(){

            @Override
            public void apply(Object item, ItemEnchantments itemEnchantments) {
                ItemStack itemStack = (ItemStack)item;
                NBTTagCompound tag = itemStack.u();
                if (itemEnchantments == null) {
                    tag.r("StoredEnchantments");
                    return;
                }
                for (Map.Entry<org.bukkit.enchantments.Enchantment, Integer> entry : itemEnchantments.entrySet()) {
                    ItemEnchantedBook.a((ItemStack)itemStack, (WeightedRandomEnchant)new WeightedRandomEnchant(CraftEnchantment.getRaw((org.bukkit.enchantments.Enchantment)entry.getKey()), entry.getValue().intValue()));
                }
            }

            @Override
            public ItemEnchantments get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                NBTTagCompound tag = itemStack.t();
                Map enchants = EnchantmentManager.a((ItemStack)itemStack);
                HashMap<org.bukkit.enchantments.Enchantment, Integer> enchantments = new HashMap<org.bukkit.enchantments.Enchantment, Integer>();
                for (Map.Entry entry : enchants.entrySet()) {
                    enchantments.put(DataComponentImpl.minecraftToBukkit((Enchantment)entry.getKey()), (Integer)entry.getValue());
                }
                return new ItemEnchantments(enchantments, tag == null ? true : !DataComponentImpl.hasItemFlag(tag, ItemFlag.HIDE_ENCHANTS));
            }
        };
    }

    @Override
    public DataComponent<ProfileProperties> profile() {
        return new DataComponent<ProfileProperties>(){

            @Override
            public void apply(Object item, ProfileProperties profileProperties) {
                ItemStack itemStack = (ItemStack)item;
                NBTTagCompound tag = itemStack.u();
                if (profileProperties == null) {
                    tag.r("SkullOwner");
                    return;
                }
                NBTTagCompound skullOwner = new NBTTagCompound();
                skullOwner.a("Name", "skull");
                NBTTagCompound properties = new NBTTagCompound();
                NBTTagList textures = new NBTTagList();
                NBTTagCompound val = new NBTTagCompound();
                val.a("Value", ((ProfileProperties.Property)profileProperties.properties().get((Object)"textures").stream().findFirst().get()).value());
                textures.add((Object)val);
                properties.a("textures", (NBTBase)textures);
                skullOwner.a("Properties", (NBTBase)properties);
                tag.a("SkullOwner", (NBTBase)skullOwner);
            }

            @Override
            public ProfileProperties get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                NBTTagCompound tag = itemStack.t();
                if (tag == null || tag.f()) {
                    return null;
                }
                ProfileProperties profileProperties = new ProfileProperties(UUID.randomUUID(), "skull");
                NBTTagCompound skullOwner = tag.p("SkullOwner");
                NBTTagCompound propertiesTag = skullOwner.p("Properties");
                NBTTagList listTag = propertiesTag.c("textures", 10);
                String textures = "";
                Iterator iterator = listTag.iterator();
                if (iterator.hasNext()) {
                    NBTBase tag1 = (NBTBase)iterator.next();
                    NBTTagCompound compoundTag = (NBTTagCompound)tag1;
                    textures = compoundTag.l("Value");
                }
                profileProperties.put("textures", new ProfileProperties.Property("textures", textures, null));
                return profileProperties;
            }
        };
    }

    @Override
    public DataComponent<Material> material() {
        return new DataComponent<Material>(){

            @Override
            public void apply(Object item, Material material) {
                ItemStack itemStack = (ItemStack)item;
                if (material == Material.AIR) {
                    itemStack.c(null);
                }
                itemStack.setItem(CraftMagicNumbers.getItem((Material)material));
            }

            @Override
            public Material get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                return CraftMagicNumbers.getMaterial((Item)itemStack.c());
            }
        };
    }

    @Override
    public DataComponent<DyedColor> dyedColor() {
        return new DataComponent<DyedColor>(){

            @Override
            public void apply(Object item, DyedColor dyedColor) {
                ItemStack itemStack = (ItemStack)item;
                NBTTagCompound tag = itemStack.u();
                if (dyedColor == null) {
                    tag.r("Color");
                    return;
                }
                DataComponentImpl.setDisplayTag(tag, "Color", (NBTBase)NBTTagInt.a((int)dyedColor.rgb()));
            }

            @Override
            public DyedColor get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                NBTTagCompound tag = itemStack.t();
                if (tag == null) {
                    return new DyedColor(Color.fromRGB((int)0), true);
                }
                return new DyedColor(Color.fromRGB((int)tag.h("Color")), DataComponentImpl.hasItemFlag(tag, ItemFlag.HIDE_DYE));
            }
        };
    }

    @Override
    public DataComponent<PotionType> potionType() {
        return new DataComponent<PotionType>(){

            @Override
            public void apply(Object item, PotionType potionType) {
                ItemStack itemStack = (ItemStack)item;
                NBTTagCompound tag = itemStack.u();
                if (potionType == null) {
                    tag.r("Potion");
                    return;
                }
                tag.a("Potion", CraftPotionUtil.fromBukkit((PotionData)new PotionData(potionType)));
            }

            @Override
            public PotionType get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                NBTTagCompound tag = itemStack.t();
                if (tag == null) {
                    return PotionType.AWKWARD;
                }
                return CraftPotionUtil.toBukkit((String)tag.l("Potion")).getType();
            }
        };
    }
}

