/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.axapi.nms.v1_18_R1.utils;

import com.artillexstudios.axvaults.libs.kyori.adventure.text.Component;
import com.artillexstudios.axvaults.libs.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import com.google.gson.JsonElement;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundClearTitlesPacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class Title
implements com.artillexstudios.axvaults.libs.axapi.utils.Title {
    private Component title;
    private Component subTitle;
    private int fadeInTime;
    private int stayTime;
    private int fadeOutTime;
    private ClientboundSetTitleTextPacket titleTextPacket;
    private ClientboundSetTitlesAnimationPacket animationPacket;
    private ClientboundSetSubtitleTextPacket subtitleTextPacket;

    public Title(Component title, Component subTitle, int fadeInTime, int stayTime, int fadeOutTime) {
        this.title = title;
        this.subTitle = subTitle;
        this.fadeInTime = fadeInTime;
        this.stayTime = stayTime;
        this.fadeOutTime = fadeOutTime;
        this.updatePackets();
    }

    @Override
    public void setTitle(@Nullable Component title) {
        this.title = title;
        this.updatePackets();
    }

    @Override
    public void setSubTitle(@Nullable Component subTitle) {
        this.subTitle = subTitle;
        this.updatePackets();
    }

    @Override
    public void set(@Nullable Component title, @Nullable Component subTitle) {
        this.title = title;
        this.subTitle = subTitle;
        this.updatePackets();
    }

    @Override
    public void set(@Nullable Component title, @Nullable Component subTitle, int fadeIn, int stay, int fadeOut) {
        this.title = title;
        this.subTitle = subTitle;
        this.fadeInTime = fadeIn;
        this.stayTime = stay;
        this.fadeOutTime = fadeOut;
        this.updatePackets();
    }

    @Override
    public void setTimes(int fadeIn, int stay, int fadeOut) {
        this.fadeInTime = fadeIn;
        this.stayTime = stay;
        this.fadeOutTime = fadeOut;
        this.updatePackets();
    }

    @Override
    public void setFadeInTime(int fadeIn) {
        this.fadeInTime = fadeIn;
        this.updatePackets();
    }

    @Override
    public void setStayTime(int stayTime) {
        this.stayTime = stayTime;
        this.updatePackets();
    }

    @Override
    public void setFadeOutTime(int fateOut) {
        this.fadeOutTime = fateOut;
        this.updatePackets();
    }

    @Override
    public void send(Player player) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        serverPlayer.b.a((Packet)this.animationPacket);
        if (this.titleTextPacket != null) {
            serverPlayer.b.a((Packet)this.titleTextPacket);
        }
        if (this.subtitleTextPacket != null) {
            serverPlayer.b.a((Packet)this.subtitleTextPacket);
        }
    }

    @Override
    public void clear(Player player) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        serverPlayer.b.a((Packet)new ClientboundClearTitlesPacket(true));
    }

    private void updatePackets() {
        this.titleTextPacket = this.title == null || this.title == Component.empty() ? null : new ClientboundSetTitleTextPacket((IChatBaseComponent)IChatBaseComponent.ChatSerializer.a((JsonElement)GsonComponentSerializer.gson().serializer().toJsonTree(this.title)));
        this.subtitleTextPacket = this.subTitle == null || this.subTitle == Component.empty() ? null : new ClientboundSetSubtitleTextPacket((IChatBaseComponent)IChatBaseComponent.ChatSerializer.a((JsonElement)GsonComponentSerializer.gson().serializer().toJsonTree(this.subTitle)));
        this.animationPacket = new ClientboundSetTitlesAnimationPacket(this.fadeInTime, this.stayTime, this.fadeOutTime);
    }
}

