/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.axapi.nms.v1_18_R1.entity;

import com.artillexstudios.axvaults.libs.axapi.AxPlugin;
import com.artillexstudios.axvaults.libs.axapi.collections.ThreadSafeList;
import com.artillexstudios.axvaults.libs.axapi.events.PacketEntityInteractEvent;
import com.artillexstudios.axvaults.libs.axapi.hologram.HologramLine;
import com.artillexstudios.axvaults.libs.axapi.hologram.Holograms;
import com.artillexstudios.axvaults.libs.axapi.items.WrappedItemStack;
import com.artillexstudios.axvaults.libs.axapi.nms.NMSHandlers;
import com.artillexstudios.axvaults.libs.axapi.nms.v1_18_R1.entity.Serializers;
import com.artillexstudios.axvaults.libs.axapi.nms.v1_18_R1.entity.VecDeltaCodec;
import com.artillexstudios.axvaults.libs.axapi.packetentity.meta.EntityMeta;
import com.artillexstudios.axvaults.libs.axapi.packetentity.meta.EntityMetaFactory;
import com.artillexstudios.axvaults.libs.axapi.packetentity.meta.Metadata;
import com.artillexstudios.axvaults.libs.axapi.packetentity.tracker.EntityTracker;
import com.artillexstudios.axvaults.libs.axapi.utils.EquipmentSlot;
import com.artillexstudios.axvaults.libs.axapi.utils.StringUtils;
import com.artillexstudios.axvaults.libs.axapi.utils.placeholder.Placeholder;
import com.artillexstudios.axvaults.libs.axapi.utils.placeholder.StaticPlaceholder;
import com.artillexstudios.axvaults.libs.kyori.adventure.text.Component;
import com.artillexstudios.axvaults.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import com.artillexstudios.axvaults.libs.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftPlayer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class PacketEntity
implements com.artillexstudios.axvaults.libs.axapi.packetentity.PacketEntity {
    private final int id;
    private final EntityMeta meta;
    private final EntityTypes<?> type;
    private final VecDeltaCodec codec = new VecDeltaCodec();
    private final Set<Player> invertedVisibilityEntities = Collections.newSetFromMap(new WeakHashMap());
    private final NonNullList<ItemStack> handSlots;
    private final NonNullList<ItemStack> armorSlots;
    private Location location;
    private EntityTracker.TrackedEntity tracker;
    private List<DataWatcher.Item<?>> trackedValues;
    private Vec3D vec3;
    private volatile boolean shouldTeleport = false;
    private volatile boolean itemDirty = false;
    private boolean visibleByDefault = true;
    private int riddenEntityId = -1;
    private Consumer<PacketEntityInteractEvent> interactConsumer;

    public PacketEntity(EntityType entityType, Location location) {
        this.id = NMSHandlers.getNmsHandler().nextEntityId();
        this.type = EntityTypes.a((String)entityType.getName()).orElse(EntityTypes.c);
        this.meta = EntityMetaFactory.getForType(entityType);
        this.location = location;
        this.handSlots = NonNullList.a((int)2, (Object)ItemStack.b);
        this.armorSlots = NonNullList.a((int)4, (Object)ItemStack.b);
    }

    private static List<DataWatcher.Item<?>> transform(List<Metadata.DataItem<?>> toTransform) {
        ArrayList<DataWatcher.Item> dataValues = null;
        if (toTransform != null) {
            dataValues = new ArrayList<DataWatcher.Item>(toTransform.size());
            for (Metadata.DataItem<?> dataItem : toTransform) {
                Serializers.Transformer transformer = Serializers.transformer(dataItem.getAccessor());
                dataValues.add(new DataWatcher.Item(transformer.serializer().a(dataItem.getAccessor().id()), transformer.transform(dataItem.getValue())));
            }
        }
        return dataValues;
    }

    private static PacketPlayOutSpawnEntity getAddEntityPacket(PacketEntity entity) {
        return new PacketPlayOutSpawnEntity(entity.id(), UUID.randomUUID(), entity.location().getX(), entity.location().getY(), entity.location().getZ(), entity.location().getPitch(), entity.location().getYaw(), entity.type, 1, Vec3D.a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void teleport(Location location) {
        this.location = location;
        VecDeltaCodec vecDeltaCodec = this.codec;
        synchronized (vecDeltaCodec) {
            this.vec3 = new Vec3D(location.getX(), location.getY(), location.getZ());
            this.shouldTeleport = true;
        }
    }

    @Override
    public Location location() {
        return this.location;
    }

    @Override
    public EntityMeta meta() {
        return this.meta;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public void spawn() {
        this.meta.metadata().markNotDirty();
        this.trackedValues = PacketEntity.transform(this.meta.metadata().getNonDefaultValues());
        AxPlugin.tracker.addEntity(this);
    }

    @Override
    public void hide(Player player) {
        if (this.visibleByDefault) {
            this.invertedVisibilityEntities.add(player);
        } else {
            this.invertedVisibilityEntities.remove(player);
        }
    }

    @Override
    public void show(Player player) {
        if (this.visibleByDefault) {
            this.invertedVisibilityEntities.remove(player);
        } else {
            this.invertedVisibilityEntities.add(player);
        }
    }

    @Override
    public void setVisibleByDefault(boolean visible) {
        this.visibleByDefault = visible;
    }

    @Override
    public void setItem(EquipmentSlot slot, WrappedItemStack item) {
        if (slot.getType() == EquipmentSlot.Type.HAND) {
            this.handSlots.set(slot.getIndex(), (Object)(item == null ? ItemStack.b : ((com.artillexstudios.axvaults.libs.axapi.nms.v1_18_R1.items.WrappedItemStack)item).parent));
        } else {
            this.armorSlots.set(slot.getIndex(), (Object)(item == null ? ItemStack.b : ((com.artillexstudios.axvaults.libs.axapi.nms.v1_18_R1.items.WrappedItemStack)item).parent));
        }
        this.itemDirty = true;
    }

    @Override
    public WrappedItemStack getItem(EquipmentSlot slot) {
        return new com.artillexstudios.axvaults.libs.axapi.nms.v1_18_R1.items.WrappedItemStack(slot.getType() == EquipmentSlot.Type.ARMOR ? (ItemStack)this.armorSlots.get(slot.getIndex()) : (ItemStack)this.handSlots.get(slot.getIndex()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendChanges() {
        List<DataWatcher.Item<?>> dirty;
        if (this.meta.metadata().isDirty() && (dirty = PacketEntity.transform(this.meta.metadata().packDirty())) != null) {
            this.trackedValues = PacketEntity.transform(this.meta.metadata().getNonDefaultValues());
            HologramLine line = Holograms.byId(this.id);
            if (line == null || !line.hasPlaceholders()) {
                buf = new PacketDataSerializer(Unpooled.buffer());
                buf.d(this.id);
                DataWatcher.a(dirty, (PacketDataSerializer)buf);
                this.tracker.broadcast(new PacketPlayOutEntityMetadata(buf));
                buf.release();
            } else {
                buf = new PacketDataSerializer(Unpooled.buffer());
                for (Player player : this.tracker.seenBy) {
                    buf.d(this.id);
                    DataWatcher.a(this.translate(player, line, dirty), (PacketDataSerializer)buf);
                    NMSHandlers.getNmsHandler().sendPacket(player, new PacketPlayOutEntityMetadata(buf));
                    buf.clear();
                }
                buf.release();
            }
        }
        if (this.itemDirty) {
            this.itemDirty = false;
            ArrayList equipments = Lists.newArrayList();
            for (EnumItemSlot slot : EnumItemSlot.values()) {
                ItemStack item = this.getItemBySlot(slot);
                if (item != null && !item.b()) {
                    ItemStack sanitised = item.m();
                    equipments.add(Pair.of((Object)slot, (Object)sanitised));
                    continue;
                }
                equipments.add(Pair.of((Object)slot, (Object)ItemStack.b));
            }
            if (!equipments.isEmpty()) {
                this.tracker.broadcast(new PacketPlayOutEntityEquipment(this.id, (List)equipments));
            }
        }
        if (this.shouldTeleport) {
            VecDeltaCodec vecDeltaCodec = this.codec;
            synchronized (vecDeltaCodec) {
                this.shouldTeleport = false;
                long k = this.codec.encodeX(this.vec3);
                long l = this.codec.encodeY(this.vec3);
                long i1 = this.codec.encodeZ(this.vec3);
                boolean flag6 = k < -32768L || k > 32767L || l < -32768L || l > 32767L || i1 < -32768L || i1 > 32767L;
                this.codec.setBase(this.vec3);
                if (!flag6) {
                    this.tracker.broadcast(new PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook(this.id, (short)k, (short)l, (short)i1, (byte)(this.location.getYaw() * 256.0f / 360.0f), (byte)(this.location.getPitch() * 256.0f / 360.0f), true));
                } else {
                    PacketDataSerializer byteBuf = new PacketDataSerializer(Unpooled.buffer());
                    byteBuf.d(this.id);
                    byteBuf.writeDouble(this.location.getX());
                    byteBuf.writeDouble(this.location.getY());
                    byteBuf.writeDouble(this.location.getZ());
                    byteBuf.writeByte((int)((byte)(this.location.getYaw() * 256.0f / 360.0f)));
                    byteBuf.writeByte((int)((byte)(this.location.getPitch() * 256.0f / 360.0f)));
                    byteBuf.writeBoolean(true);
                    this.tracker.broadcast(new PacketPlayOutEntityTeleport(byteBuf));
                    byteBuf.release();
                }
            }
        }
    }

    @Override
    public void removePairing(Player player) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        serverPlayer.b.a((Packet)new PacketPlayOutEntityDestroy(new int[]{this.id}));
    }

    @Override
    public void addPairing(Player player) {
        PacketDataSerializer buf;
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        serverPlayer.b.a((Packet)PacketEntity.getAddEntityPacket(this));
        if (this.trackedValues != null) {
            HologramLine line = Holograms.byId(this.id);
            buf = new PacketDataSerializer(Unpooled.buffer());
            buf.d(this.id);
            if (line == null || line.type() != HologramLine.Type.TEXT || !line.hasPlaceholders()) {
                DataWatcher.a(this.trackedValues, (PacketDataSerializer)buf);
            } else {
                DataWatcher.a(this.translate(player, line, this.trackedValues), (PacketDataSerializer)buf);
            }
            serverPlayer.b.a((Packet)new PacketPlayOutEntityMetadata(buf));
            buf.release();
        }
        ArrayList equipments = Lists.newArrayList();
        for (PacketDataSerializer slot : EnumItemSlot.values()) {
            ItemStack item = this.getItemBySlot((EnumItemSlot)slot);
            if (item == null || item.b()) continue;
            ItemStack sanitised = item.m();
            equipments.add(Pair.of((Object)slot, (Object)sanitised));
        }
        if (!equipments.isEmpty()) {
            serverPlayer.b.a((Packet)new PacketPlayOutEntityEquipment(this.id, (List)equipments));
        }
        if (this.riddenEntityId != -1) {
            buf = new PacketDataSerializer(Unpooled.buffer());
            buf.d(this.riddenEntityId);
            buf.a(new int[]{this.id});
            serverPlayer.b.a((Packet)new PacketPlayOutMount(buf));
            buf.release();
        }
    }

    @Override
    public boolean canSee(Player player) {
        return this.visibleByDefault ^ this.invertedVisibilityEntities.contains(player);
    }

    @Override
    public void remove() {
        AxPlugin.tracker.removeEntity(this);
        this.location = null;
    }

    @Override
    public void onInteract(Consumer<PacketEntityInteractEvent> event) {
        this.interactConsumer = event;
    }

    @Override
    public void callInteract(PacketEntityInteractEvent event) {
        if (this.interactConsumer != null) {
            this.interactConsumer.accept(event);
        }
    }

    @Override
    public void ride(int entityId) {
        this.unRide(this.riddenEntityId);
        this.riddenEntityId = entityId;
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        buf.d(this.riddenEntityId);
        buf.a(new int[]{this.id});
        this.tracker.broadcast(new PacketPlayOutMount(buf));
        buf.release();
    }

    @Override
    public void unRide(int entityId) {
        if (this.riddenEntityId == -1) {
            return;
        }
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        buf.d(this.riddenEntityId);
        buf.a(new int[0]);
        this.tracker.broadcast(new PacketPlayOutMount(buf));
        buf.release();
        this.riddenEntityId = -1;
    }

    @Override
    public void update() {
        List<DataWatcher.Item<?>> transformed = PacketEntity.transform(this.meta.metadata().packForNameUpdate());
        HologramLine line = Holograms.byId(this.id);
        if (line == null) {
            return;
        }
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        for (Player player : this.tracker.seenBy) {
            buf.d(this.id);
            DataWatcher.a(this.translate(player, line, transformed), (PacketDataSerializer)buf);
            NMSHandlers.getNmsHandler().sendPacket(player, new PacketPlayOutEntityMetadata(buf));
            buf.clear();
        }
        buf.release();
    }

    private List<DataWatcher.Item<?>> translate(Player player, HologramLine line, List<DataWatcher.Item<?>> values) {
        ArrayList dataValues = new ArrayList(values);
        ListIterator<DataWatcher.Item> iterator = dataValues.listIterator();
        while (iterator.hasNext()) {
            DataWatcher.Item value = (DataWatcher.Item)iterator.next();
            if (value.a().a() != 2 || line.type() != HologramLine.Type.TEXT) continue;
            Optional content = (Optional)value.b();
            if (content.isEmpty()) {
                return values;
            }
            String legacy = (String)legacyCache.get(content.get(), minecraftComponent -> {
                String gsonText = IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)((IChatBaseComponent)minecraftComponent));
                Object gsonComponent = GsonComponentSerializer.gson().deserialize(gsonText);
                return LEGACY_COMPONENT_SERIALIZER.serialize((Component)gsonComponent);
            });
            if (legacy == null) {
                return values;
            }
            ThreadSafeList<Placeholder> placeholders = line.placeholders();
            for (int i = 0; i < placeholders.size(); ++i) {
                Placeholder placeholder = placeholders.get(i);
                if (placeholder instanceof StaticPlaceholder) continue;
                legacy = placeholder.parse(player, legacy);
            }
            IChatBaseComponent component = (IChatBaseComponent)componentCache.get((Object)legacy, legacyText -> {
                Component formatted = StringUtils.format(legacyText, new TagResolver[0]);
                String gson = (String)GsonComponentSerializer.gson().serialize(formatted);
                return IChatBaseComponent.ChatSerializer.a((String)gson);
            });
            iterator.remove();
            iterator.add(new DataWatcher.Item(value.a(), Optional.ofNullable(component)));
            break;
        }
        return dataValues;
    }

    private ItemStack getItemBySlot(EnumItemSlot slot) {
        return switch (slot.a()) {
            default -> throw new IncompatibleClassChangeError();
            case EnumItemSlot.Function.b -> (ItemStack)this.armorSlots.get(slot.b());
            case EnumItemSlot.Function.a -> (ItemStack)this.handSlots.get(slot.b());
        };
    }
}

