/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.axapi.nms;

import com.artillexstudios.axvaults.libs.axapi.nms.NMSHandler;
import com.artillexstudios.axvaults.libs.axapi.utils.Version;
import org.bukkit.plugin.java.JavaPlugin;

public class NMSHandlers {
    private static NMSHandler nmsHandler;

    private static boolean init(JavaPlugin plugin) {
        Version version = Version.getServerVersion();
        if (nmsHandler == null) {
            try {
                nmsHandler = (NMSHandler)Class.forName(String.format("com.artillexstudios.axvaults.libs.axapi.nms.%s.NMSHandler", version.nmsVersion)).getConstructor(JavaPlugin.class).newInstance(plugin);
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public static NMSHandler getNmsHandler() {
        if (nmsHandler == null) {
            throw new RuntimeException("NMSHandler has not been initialised! This could be due to incorrect usage, or unsupported NMS version!");
        }
        return nmsHandler;
    }

    public static class American {
        public static boolean initialize(JavaPlugin plugin) {
            return NMSHandlers.init(plugin);
        }
    }

    public static class British {
        public static boolean initialise(JavaPlugin plugin) {
            return NMSHandlers.init(plugin);
        }
    }
}

