/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.axapi.items.component;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.enchantments.Enchantment;

public class ItemEnchantments {
    private final HashMap<Enchantment, Integer> enchantments;
    private final boolean showInTooltip;

    public ItemEnchantments(HashMap<Enchantment, Integer> enchantments, boolean showInTooltip) {
        this.enchantments = enchantments;
        this.showInTooltip = showInTooltip;
    }

    public ItemEnchantments remove(Enchantment enchantment) {
        HashMap copy = (HashMap)this.enchantments.clone();
        copy.remove(enchantment);
        return new ItemEnchantments(copy, this.showInTooltip);
    }

    public ItemEnchantments add(Enchantment enchantment, int level) {
        if (level <= 0) {
            return this.remove(enchantment);
        }
        HashMap copy = (HashMap)this.enchantments.clone();
        copy.put(enchantment, Math.min(level, 255));
        return new ItemEnchantments(copy, this.showInTooltip);
    }

    public boolean showInTooltip() {
        return this.showInTooltip;
    }

    public ItemEnchantments withTooltip(boolean showInTooltip) {
        return new ItemEnchantments(this.enchantments, showInTooltip);
    }

    public Set<Enchantment> keySet() {
        return Collections.unmodifiableSet(this.enchantments.keySet());
    }

    public Set<Map.Entry<Enchantment, Integer>> entrySet() {
        return Collections.unmodifiableSet(this.enchantments.entrySet());
    }

    public int getLevel(Enchantment enchantment) {
        return this.enchantments.get(enchantment);
    }

    public int size() {
        return this.enchantments.size();
    }

    public boolean isEmpty() {
        return this.enchantments.isEmpty();
    }
}

