/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.axapi.hologram;

import com.artillexstudios.axvaults.libs.axapi.collections.ThreadSafeList;
import com.artillexstudios.axvaults.libs.axapi.events.PacketEntityInteractEvent;
import com.artillexstudios.axvaults.libs.axapi.hologram.Hologram;
import com.artillexstudios.axvaults.libs.axapi.hologram.HologramLine;
import com.artillexstudios.axvaults.libs.axapi.utils.placeholder.Placeholder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class HologramPage {
    private final ObjectArrayList<Placeholder> placeholders = new ObjectArrayList(5);
    private final ThreadSafeList<HologramLine> lines = new ThreadSafeList();
    private final Hologram hologram;
    private Consumer<PacketEntityInteractEvent> event;

    public HologramPage(Hologram hologram) {
        this.hologram = hologram;
        this.event = hologram.event();
    }

    public void addPlaceholder(Placeholder placeholder) {
        this.placeholders.add((Object)placeholder);
        for (int i = 0; i < this.lines.size(); ++i) {
            HologramLine line = this.lines.get(i);
            line.addPlaceholder(placeholder);
        }
    }

    public ObjectArrayList<Placeholder> placeholders() {
        return this.placeholders;
    }

    public HologramLine getLine(int lineIndex) {
        return this.lines.get(lineIndex);
    }

    public boolean isFirstPage() {
        return this.hologram.page(0) == this;
    }

    public HologramLine addLine(String content, HologramLine.Type type) {
        ArrayList<Placeholder> placeholders = new ArrayList<Placeholder>(this.hologram.placeholders().size() + this.placeholders.size());
        placeholders.addAll((Collection<Placeholder>)this.hologram.placeholders());
        placeholders.addAll((Collection<Placeholder>)this.placeholders());
        HologramLine hologramLine = new HologramLine(this, this.getLocationRel(this.lines.size()), content, type, placeholders);
        this.addLine(hologramLine);
        return hologramLine;
    }

    public void addLine(HologramLine line) {
        this.lines.add(line);
        this.realign();
    }

    public void hide(Player player) {
        for (int i = 0; i < this.lines.size(); ++i) {
            HologramLine line = this.lines.get(i);
            line.hide(player);
        }
    }

    public void show(Player player) {
        for (int i = 0; i < this.lines.size(); ++i) {
            HologramLine line = this.lines.get(i);
            line.show(player);
        }
    }

    public void removeLine(int lineIndex) {
        this.lines.remove(lineIndex);
    }

    public void realign() {
        for (int i = 0; i < this.lines.size(); ++i) {
            HologramLine line = this.lines.get(i);
            line.teleport(this.getLocationRel(i));
        }
    }

    public void remove() {
        for (int i = 0; i < this.lines.size(); ++i) {
            HologramLine line = this.lines.get(i);
            line.remove();
        }
        this.lines.clear();
    }

    public void event(Consumer<PacketEntityInteractEvent> event) {
        this.event = event;
        for (int i = 0; i < this.lines.size(); ++i) {
            HologramLine line = this.lines.get(i);
            if (line.event() != null) continue;
            line.event(event);
        }
    }

    public Consumer<PacketEntityInteractEvent> event() {
        return this.event;
    }

    public Hologram hologram() {
        return this.hologram;
    }

    public ThreadSafeList<HologramLine> lines() {
        return this.lines;
    }

    private Location getLocationRel(int line) {
        return this.hologram.location().clone().add(0.0, -this.hologram.lineSpace() * (double)line, 0.0);
    }
}

