/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.axapi;

import com.artillexstudios.axvaults.libs.axapi.events.PacketEntityInteractEvent;
import com.artillexstudios.axvaults.libs.axapi.hologram.Holograms;
import com.artillexstudios.axvaults.libs.axapi.items.component.DataComponents;
import com.artillexstudios.axvaults.libs.axapi.libs.libby.BukkitLibraryManager;
import com.artillexstudios.axvaults.libs.axapi.libs.libby.Library;
import com.artillexstudios.axvaults.libs.axapi.libs.libby.logging.LogLevel;
import com.artillexstudios.axvaults.libs.axapi.nms.NMSHandlers;
import com.artillexstudios.axvaults.libs.axapi.packetentity.tracker.EntityTracker;
import com.artillexstudios.axvaults.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axvaults.libs.axapi.utils.FeatureFlags;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ConcurrentModificationException;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AxPlugin
extends JavaPlugin {
    private static final Logger log = LoggerFactory.getLogger(AxPlugin.class);
    public static EntityTracker tracker;
    private static boolean hasNMSHandler;

    public AxPlugin() {
        this.updateFlags();
    }

    public void updateFlags() {
    }

    public void onEnable() {
        Scheduler.scheduler.init(this);
        if (hasNMSHandler) {
            if (tracker != null) {
                Executors.newScheduledThreadPool(FeatureFlags.PACKET_ENTITY_TRACKER_THREADS.get(), new ThreadFactoryBuilder().setUncaughtExceptionHandler((thread, exception) -> log.error("Thread {} threw an uncaught exception!", (Object)thread, (Object)exception)).build()).scheduleAtFixedRate(() -> {
                    try {
                        tracker.process();
                    }
                    catch (Exception exception) {
                        if (exception instanceof ConcurrentModificationException) {
                            return;
                        }
                        log.error("An unexpected error occurred while processing packet entities via the tracker!", (Throwable)exception);
                    }
                }, 0L, 50L, TimeUnit.MILLISECONDS);
            }
            Bukkit.getPluginManager().registerEvents(new Listener(){

                @EventHandler
                public void onPlayerQuitEvent(@NotNull PlayerQuitEvent event) {
                    NMSHandlers.getNmsHandler().uninjectPlayer(event.getPlayer());
                }

                @EventHandler
                public void onPlayerJoinEvent(@NotNull PlayerJoinEvent event) {
                    NMSHandlers.getNmsHandler().injectPlayer(event.getPlayer());
                }

                @EventHandler
                public void onPacketEntityInteractEvent(@NotNull PacketEntityInteractEvent event) {
                    event.getPacketEntity().callInteract(event);
                }

                @EventHandler
                public void onPlayerChangedWorldEvent(@NotNull PlayerChangedWorldEvent event) {
                    if (tracker == null) {
                        return;
                    }
                    tracker.untrackFor(event.getPlayer());
                }
            }, (Plugin)this);
            if (FeatureFlags.HOLOGRAM_UPDATE_TICKS.get() > 0L) {
                Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(() -> Holograms.getMap(map -> map.forEach((id, line) -> {
                    if (!line.hasPlaceholders()) {
                        return;
                    }
                    line.update();
                })), 0L, FeatureFlags.HOLOGRAM_UPDATE_TICKS.get() * 50L, TimeUnit.MILLISECONDS);
            }
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            NMSHandlers.getNmsHandler().injectPlayer(player);
        }
        this.enable();
    }

    public void enable() {
    }

    public void onLoad() {
        BukkitLibraryManager libraryManager = new BukkitLibraryManager((Plugin)this);
        libraryManager.addMavenCentral();
        Library commonsMath = Library.builder().groupId("org{}apache{}commons").artifactId("commons-math3").version("3.6.1").relocate("org{}apache{}commons{}math3", "com.artillexstudios.axvaults.libs.axapi.libs.math3").build();
        Library caffeine = Library.builder().groupId("com{}github{}ben-manes{}caffeine").artifactId("caffeine").version("3.1.8").relocate("com{}github{}benmanes", "com.artillexstudios.axvaults.libs.axapi.libs.caffeine").build();
        libraryManager.setLogLevel(LogLevel.DEBUG);
        libraryManager.loadLibrary(commonsMath);
        libraryManager.loadLibrary(caffeine);
        hasNMSHandler = NMSHandlers.British.initialise(this);
        DataComponents.setDataComponentImpl(NMSHandlers.getNmsHandler().dataComponents());
        this.load();
        if (hasNMSHandler && FeatureFlags.PACKET_ENTITY_TRACKER_ENABLED.get().booleanValue()) {
            tracker = new EntityTracker();
        }
    }

    public void load() {
    }

    public void onDisable() {
        this.disable();
        Scheduler.get().cancelAll();
        for (Player player : Bukkit.getOnlinePlayers()) {
            NMSHandlers.getNmsHandler().uninjectPlayer(player);
        }
    }

    public void disable() {
    }

    public void reload() {
    }

    public long reloadWithTime() {
        long start = System.currentTimeMillis();
        this.reload();
        return System.currentTimeMillis() - start;
    }
}

