/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.converters;

import com.artillexstudios.axvaults.AxVaults;
import com.artillexstudios.axvaults.libs.axapi.config.Config;
import com.artillexstudios.axvaults.libs.axapi.utils.StringUtils;
import com.artillexstudios.axvaults.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import com.artillexstudios.axvaults.vaults.Vault;
import java.io.File;
import java.lang.reflect.Method;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class PlayerVaultsXConverter {
    public void run() {
        File path = new File(Bukkit.getWorldContainer(), "plugins/PlayerVaults/newvaults");
        if (path.exists()) {
            int vaults = 0;
            int players = 0;
            for (File file : path.listFiles()) {
                UUID uuid;
                if (!file.getName().endsWith(".yml")) continue;
                Config data = new Config(file);
                try {
                    uuid = UUID.fromString(file.getName().replace(".yml", ""));
                }
                catch (Exception ex) {
                    continue;
                }
                ++players;
                for (String route : data.getBackingDocument().getRoutesAsStrings(false)) {
                    int num = Integer.parseInt(route.replace("vault", ""));
                    Vault vault = new Vault(uuid, num, null);
                    vault.setContents(this.getItems(data.getString(route)), unused -> AxVaults.getDatabase().saveVault(vault));
                    ++vaults;
                }
            }
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxVaults] Finished converting " + vaults + " vaults of " + players + " players!", new TagResolver[0]));
            return;
        }
        Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF0000[AxVaults] Failed converting! Folder not found!", new TagResolver[0]));
    }

    private ItemStack[] getItems(String base64) {
        try {
            byte[] bytes = Base64Coder.decodeLines((String)base64);
            Class<?> cl = Class.forName("com.drtshock.playervaults.vaultmanagement.CardboardBoxSerialization");
            Method method = cl.getDeclaredMethod("readInventory", byte[].class);
            method.setAccessible(true);
            return (ItemStack[])method.invoke(null, new Object[]{bytes});
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

