/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.commands;

import com.artillexstudios.axvaults.AxVaults;
import com.artillexstudios.axvaults.converters.PlayerVaultsXConverter;
import com.artillexstudios.axvaults.guis.VaultSelector;
import com.artillexstudios.axvaults.libs.axapi.utils.StringUtils;
import com.artillexstudios.axvaults.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import com.artillexstudios.axvaults.libs.lamp.annotation.DefaultFor;
import com.artillexstudios.axvaults.libs.lamp.annotation.Optional;
import com.artillexstudios.axvaults.libs.lamp.annotation.Range;
import com.artillexstudios.axvaults.libs.lamp.annotation.Subcommand;
import com.artillexstudios.axvaults.libs.lamp.bukkit.annotation.CommandPermission;
import com.artillexstudios.axvaults.libs.lamp.orphan.OrphanCommand;
import com.artillexstudios.axvaults.vaults.Vault;
import com.artillexstudios.axvaults.vaults.VaultManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class AdminCommand
implements OrphanCommand {
    @CommandPermission(value="axvaults.admin")
    @DefaultFor(value={"~", "~ help"})
    public void help(@NotNull CommandSender sender) {
        for (String m : AxVaults.MESSAGES.getStringList("help")) {
            sender.sendMessage(StringUtils.formatToString(m, new TagResolver[0]));
        }
    }

    @CommandPermission(value="axvaults.admin.reload")
    @Subcommand(value={"reload"})
    public void reload(@NotNull CommandSender sender) {
        Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#55FF00[AxVaults] &#AAFFAAReloading configuration...", new TagResolver[0]));
        if (!AxVaults.CONFIG.reload()) {
            AxVaults.MESSAGEUTILS.sendFormatted(sender, "reload.failed", Collections.singletonMap("%file%", "config.yml"));
            return;
        }
        Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#55FF00\u2560 &#00FF00Reloaded &fconfig.yml&#00FF00!", new TagResolver[0]));
        if (!AxVaults.MESSAGES.reload()) {
            AxVaults.MESSAGEUTILS.sendFormatted(sender, "reload.failed", Collections.singletonMap("%file%", "messages.yml"));
            return;
        }
        Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#55FF00\u2560 &#00FF00Reloaded &fmessages.yml&#00FF00!", new TagResolver[0]));
        VaultManager.reload();
        Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#55FF00\u2560 &#00FF00Reloaded &fvaults&#00FF00!", new TagResolver[0]));
        AxVaults.registerCommands();
        Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#55FF00\u255a &#00FF00Successful reload!", new TagResolver[0]));
        AxVaults.MESSAGEUTILS.sendLang(sender, "reload.success", new TagResolver[0]);
    }

    @CommandPermission(value="axvaults.admin.forceopen")
    @Subcommand(value={"forceopen"})
    public void forceopen(@NotNull CommandSender sender, @NotNull Player player) {
        new VaultSelector().open(player);
        AxVaults.MESSAGEUTILS.sendLang(sender, "force-open", Collections.singletonMap("%player%", player.getName()));
    }

    @CommandPermission(value="axvaults.admin.view")
    @Subcommand(value={"view"})
    public void view(@NotNull Player sender, @NotNull OfflinePlayer player, @Optional @Range(min=1.0) Integer number) {
        HashMap<String, Object> replacements = new HashMap<String, Object>();
        replacements.put("%player%", player.getName());
        if (number == null) {
            VaultManager.getPlayer(player.getUniqueId(), vaultPlayer -> {
                replacements.put("%vaults%", vaultPlayer.getVaultMap().values().stream().filter(vault -> vault.getSlotsFilled() != 0).map(vault -> "" + vault.getId()).collect(Collectors.joining(", ")));
                AxVaults.MESSAGEUTILS.sendLang((CommandSender)sender, "view.info", replacements);
            });
            return;
        }
        replacements.put("%num%", "" + number);
        VaultManager.getPlayer(player.getUniqueId(), vaultPlayer -> {
            Vault vault = vaultPlayer.getVault(number);
            if (vault == null) {
                AxVaults.MESSAGEUTILS.sendLang((CommandSender)sender, "view.not-found", replacements);
                return;
            }
            vault.open(sender);
            AxVaults.MESSAGEUTILS.sendLang((CommandSender)sender, "view.open", replacements);
        });
    }

    @CommandPermission(value="axvaults.admin.delete")
    @Subcommand(value={"delete"})
    public void delete(@NotNull Player sender, @NotNull OfflinePlayer player, int number) {
        HashMap<String, Object> replacements = new HashMap<String, Object>();
        replacements.put("%player%", player.getName());
        replacements.put("%num%", "" + number);
        VaultManager.getPlayer(player.getUniqueId(), vaultPlayer -> {
            Vault vault = vaultPlayer.getVault(number);
            if (vault == null) {
                AxVaults.MESSAGEUTILS.sendLang((CommandSender)sender, "view.not-found", replacements);
                return;
            }
            VaultManager.getVaults().remove(vault);
            VaultManager.removeVault(vault);
            AxVaults.getDatabase().deleteVault(player.getUniqueId(), number);
            AxVaults.MESSAGEUTILS.sendLang((CommandSender)sender, "delete", replacements);
        });
    }

    @CommandPermission(value="axvaults.admin.set")
    @Subcommand(value={"set"})
    public void set(@NotNull Player sender, @Optional Integer number) {
        Block block = sender.getTargetBlockExact(5);
        if (block == null) {
            AxVaults.MESSAGEUTILS.sendLang((CommandSender)sender, "set.no-block", new TagResolver[0]);
            return;
        }
        AxVaults.getThreadedQueue().submit(() -> {
            if (AxVaults.getDatabase().isVault(block.getLocation())) {
                AxVaults.MESSAGEUTILS.sendLang((CommandSender)sender, "set.already", new TagResolver[0]);
                return;
            }
            AxVaults.getDatabase().setVault(block.getLocation(), number);
            AxVaults.MESSAGEUTILS.sendLang((CommandSender)sender, "set.success", new TagResolver[0]);
        });
    }

    @CommandPermission(value="axvaults.admin.converter")
    @Subcommand(value={"converter PlayerVaultsX"})
    public void converter(@NotNull Player sender) {
        new PlayerVaultsXConverter().run();
        AxVaults.MESSAGEUTILS.sendLang((CommandSender)sender, "converter.started", new TagResolver[0]);
    }
}

