/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults;

import com.artillexstudios.axvaults.commands.AdminCommand;
import com.artillexstudios.axvaults.commands.PlayerCommand;
import com.artillexstudios.axvaults.database.Database;
import com.artillexstudios.axvaults.database.impl.H2;
import com.artillexstudios.axvaults.database.impl.SQLite;
import com.artillexstudios.axvaults.libraries.Libraries;
import com.artillexstudios.axvaults.libs.axapi.AxPlugin;
import com.artillexstudios.axvaults.libs.axapi.config.Config;
import com.artillexstudios.axvaults.libs.axapi.data.ThreadedQueue;
import com.artillexstudios.axvaults.libs.axapi.libs.boostedyaml.boostedyaml.dvs.versioning.BasicVersioning;
import com.artillexstudios.axvaults.libs.axapi.libs.boostedyaml.boostedyaml.settings.dumper.DumperSettings;
import com.artillexstudios.axvaults.libs.axapi.libs.boostedyaml.boostedyaml.settings.general.GeneralSettings;
import com.artillexstudios.axvaults.libs.axapi.libs.boostedyaml.boostedyaml.settings.loader.LoaderSettings;
import com.artillexstudios.axvaults.libs.axapi.libs.boostedyaml.boostedyaml.settings.updater.UpdaterSettings;
import com.artillexstudios.axvaults.libs.axapi.libs.libby.BukkitLibraryManager;
import com.artillexstudios.axvaults.libs.axapi.nms.NMSHandlers;
import com.artillexstudios.axvaults.libs.axapi.reflection.FastFieldAccessor;
import com.artillexstudios.axvaults.libs.axapi.utils.FeatureFlags;
import com.artillexstudios.axvaults.libs.axapi.utils.MessageUtils;
import com.artillexstudios.axvaults.libs.axapi.utils.StringUtils;
import com.artillexstudios.axvaults.libs.bstats.bukkit.Metrics;
import com.artillexstudios.axvaults.libs.kyori.adventure.platform.bukkit.BukkitAudiences;
import com.artillexstudios.axvaults.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import com.artillexstudios.axvaults.libs.lamp.bukkit.BukkitCommandActor;
import com.artillexstudios.axvaults.libs.lamp.bukkit.BukkitCommandHandler;
import com.artillexstudios.axvaults.libs.lamp.bukkit.exception.InvalidPlayerException;
import com.artillexstudios.axvaults.libs.lamp.orphan.Orphans;
import com.artillexstudios.axvaults.listeners.BlackListListener;
import com.artillexstudios.axvaults.listeners.BlockBreakListener;
import com.artillexstudios.axvaults.listeners.InventoryCloseListener;
import com.artillexstudios.axvaults.listeners.JoinLeaveListener;
import com.artillexstudios.axvaults.listeners.PlayerInteractListener;
import com.artillexstudios.axvaults.schedulers.AutoSaveScheduler;
import com.artillexstudios.axvaults.utils.CommandMessages;
import com.artillexstudios.axvaults.utils.UpdateNotifier;
import com.artillexstudios.axvaults.vaults.Vault;
import com.artillexstudios.axvaults.vaults.VaultManager;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Warning;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public final class AxVaults
extends AxPlugin {
    public static Config CONFIG;
    public static Config MESSAGES;
    public static MessageUtils MESSAGEUTILS;
    private static AxPlugin instance;
    private static ThreadedQueue<Runnable> threadedQueue;
    private static Database database;
    public static BukkitAudiences BUKKITAUDIENCES;
    public static BukkitCommandHandler COMMANDHANDLER;

    public static ThreadedQueue<Runnable> getThreadedQueue() {
        return threadedQueue;
    }

    public static AxPlugin getInstance() {
        return instance;
    }

    public static Database getDatabase() {
        return database;
    }

    @Override
    public void load() {
        BukkitLibraryManager libraryManager = new BukkitLibraryManager((Plugin)this, "lib");
        libraryManager.addMavenCentral();
        for (Libraries lib : Libraries.values()) {
            libraryManager.loadLibrary(lib.getLibrary());
        }
    }

    @Override
    public void enable() {
        instance = this;
        int pluginId = 20541;
        new Metrics(this, pluginId);
        CONFIG = new Config(new File(this.getDataFolder(), "config.yml"), this.getResource("config.yml"), GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setVersioning(new BasicVersioning("version")).build());
        MESSAGES = new Config(new File(this.getDataFolder(), "messages.yml"), this.getResource("messages.yml"), GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setVersioning(new BasicVersioning("version")).build());
        MESSAGEUTILS = new MessageUtils(MESSAGES.getBackingDocument(), "prefix", CONFIG.getBackingDocument());
        BUKKITAUDIENCES = BukkitAudiences.create((Plugin)this);
        threadedQueue = new ThreadedQueue("AxVaults-Datastore-thread");
        switch (CONFIG.getString("database.type").toLowerCase()) {
            case "sqlite": {
                database = new SQLite();
                break;
            }
            default: {
                database = new H2();
            }
        }
        database.setup();
        database.load();
        this.getServer().getPluginManager().registerEvents((Listener)new JoinLeaveListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BlackListListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerInteractListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BlockBreakListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryCloseListener(), (Plugin)this);
        AxVaults.registerCommands();
        AutoSaveScheduler.start();
        Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#55ff00[AxVaults] Loaded plugin!", new TagResolver[0]));
        if (CONFIG.getBoolean("update-notifier.enabled", true)) {
            new UpdateNotifier(this, 5417);
        }
    }

    public static void registerCommands() {
        if (COMMANDHANDLER == null) {
            Warning.WarningState prevState = Bukkit.getWarningState();
            FastFieldAccessor accessor = FastFieldAccessor.forClassField(Bukkit.getServer().getClass().getPackage().getName() + ".CraftServer", "warningState");
            accessor.set(Bukkit.getServer(), Warning.WarningState.OFF);
            COMMANDHANDLER = BukkitCommandHandler.create((Plugin)instance);
            accessor.set(Bukkit.getServer(), prevState);
            COMMANDHANDLER.getAutoCompleter().registerSuggestion("vaults", (args, sender, command) -> {
                Player player = Bukkit.getPlayer((UUID)sender.getUniqueId());
                if (!player.hasPermission("axvaults.openremote")) {
                    return new ArrayList();
                }
                ArrayList<CallSite> numbers = new ArrayList<CallSite>();
                for (int i = 0; i < VaultManager.getVaultsOfPlayer(player); ++i) {
                    numbers.add((CallSite)((Object)("" + (i + 1))));
                }
                return numbers;
            });
            COMMANDHANDLER.registerValueResolver(0, OfflinePlayer.class, context -> {
                String value = context.pop();
                if (value.equalsIgnoreCase("self") || value.equalsIgnoreCase("me")) {
                    return ((BukkitCommandActor)context.actor()).requirePlayer();
                }
                OfflinePlayer player = NMSHandlers.getNmsHandler().getCachedOfflinePlayer(value);
                if (player == null && !(player = Bukkit.getOfflinePlayer((String)value)).hasPlayedBefore()) {
                    throw new InvalidPlayerException(context.parameter(), value);
                }
                return player;
            });
            COMMANDHANDLER.getAutoCompleter().registerParameterSuggestions(OfflinePlayer.class, (args, sender, command) -> Bukkit.getOnlinePlayers().stream().map(HumanEntity::getName).collect(Collectors.toSet()));
            COMMANDHANDLER.getTranslator().add(new CommandMessages());
            COMMANDHANDLER.setLocale(new Locale("en", "US"));
        }
        COMMANDHANDLER.unregisterAllCommands();
        COMMANDHANDLER.register(Orphans.path((String[])CONFIG.getStringList("player-command-aliases").toArray(String[]::new)).handler(new PlayerCommand()));
        COMMANDHANDLER.register(Orphans.path((String[])CONFIG.getStringList("admin-command-aliases").toArray(String[]::new)).handler(new AdminCommand()));
        COMMANDHANDLER.registerBrigadier();
    }

    @Override
    public void disable() {
        for (Vault vault : VaultManager.getVaults()) {
            AxVaults.getDatabase().saveVault(vault);
        }
        AutoSaveScheduler.stop();
        database.disable();
    }

    @Override
    public void updateFlags() {
        FeatureFlags.USE_LEGACY_HEX_FORMATTER.set(true);
    }
}

