/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axtrade.libs.gui.builder.gui;

import com.artillexstudios.axtrade.libs.gui.builder.gui.BaseGuiBuilder;
import com.artillexstudios.axtrade.libs.gui.builder.gui.ChestGuiBuilder;
import com.artillexstudios.axtrade.libs.gui.components.GuiContainer;
import com.artillexstudios.axtrade.libs.gui.components.GuiType;
import com.artillexstudios.axtrade.libs.gui.components.InventoryProvider;
import com.artillexstudios.axtrade.libs.gui.components.util.Legacy;
import com.artillexstudios.axtrade.libs.gui.guis.Gui;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class TypedGuiBuilder
extends BaseGuiBuilder<Gui, TypedGuiBuilder> {
    private GuiType guiType;
    private InventoryProvider.Typed inventoryProvider = (title, owner, type) -> Bukkit.createInventory((InventoryHolder)owner, (InventoryType)type, (String)Legacy.SERIALIZER.serialize(title));

    public TypedGuiBuilder(@NotNull GuiType guiType) {
        this.guiType = guiType;
    }

    public TypedGuiBuilder(@NotNull GuiType guiType, @NotNull ChestGuiBuilder builder) {
        this.guiType = guiType;
        this.consumeBuilder(builder);
    }

    @NotNull
    @Contract(value="_ -> this")
    public TypedGuiBuilder type(@NotNull GuiType guiType) {
        this.guiType = guiType;
        return this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public TypedGuiBuilder inventory(@NotNull InventoryProvider.Typed inventoryProvider) {
        this.inventoryProvider = inventoryProvider;
        return this;
    }

    @Override
    @NotNull
    @Contract(value=" -> new")
    public Gui create() {
        Gui gui = new Gui(new GuiContainer.Typed(this.getTitle(), this.inventoryProvider, this.guiType), this.getModifiers());
        Consumer consumer = this.getConsumer();
        if (consumer != null) {
            consumer.accept(gui);
        }
        return gui;
    }
}

