/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axtrade.libs.axapi.nms.v1_21_R7_paper.entity;

import com.artillexstudios.axtrade.libs.axapi.nms.v1_21_R7_paper.items.WrappedItemStack;
import com.artillexstudios.axtrade.libs.axapi.nms.v1_21_R7_paper.packet.FriendlyByteBufWrapper;
import com.artillexstudios.axtrade.libs.axapi.nms.v1_21_R7_paper.packet.PacketTransformer;
import com.artillexstudios.axtrade.libs.axapi.packetentity.meta.serializer.EntityDataSerializer;
import com.artillexstudios.axtrade.libs.axapi.packetentity.meta.serializer.EntityDataSerializers;
import com.artillexstudios.axtrade.libs.axapi.particle.ParticleData;
import com.artillexstudios.axtrade.libs.axapi.particle.ParticleTypes;
import com.artillexstudios.axtrade.libs.axapi.utils.ComponentSerializer;
import com.artillexstudios.axtrade.libs.axapi.utils.Quaternion;
import com.artillexstudios.axtrade.libs.axapi.utils.Vector3f;
import java.util.EnumMap;
import java.util.Optional;
import net.minecraft.core.Rotations;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.entity.Pose;
import org.bukkit.util.EulerAngle;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

public class Serializers {
    private static final EnumMap<EntityDataSerializers.Type, Transformer<?>> typeTransformers = new EnumMap(EntityDataSerializers.Type.class);

    public static <T, Z> Transformer<Z> transformer(EntityDataSerializer<T> accessor) {
        return typeTransformers.get((Object)accessor.type());
    }

    static {
        typeTransformers.put(EntityDataSerializers.Type.BYTE, new Transformer<Byte>(){

            @Override
            public Byte transform(Object other) {
                return (Byte)other;
            }

            @Override
            public net.minecraft.network.syncher.EntityDataSerializer<Byte> serializer() {
                return EntityDataSerializers.BYTE;
            }
        });
        typeTransformers.put(EntityDataSerializers.Type.INT, new Transformer<Integer>(){

            @Override
            public Integer transform(Object other) {
                return (Integer)other;
            }

            @Override
            public net.minecraft.network.syncher.EntityDataSerializer<Integer> serializer() {
                return EntityDataSerializers.INT;
            }
        });
        typeTransformers.put(EntityDataSerializers.Type.FLOAT, new Transformer<Float>(){

            @Override
            public Float transform(Object other) {
                return (Float)other;
            }

            @Override
            public net.minecraft.network.syncher.EntityDataSerializer<Float> serializer() {
                return EntityDataSerializers.FLOAT;
            }
        });
        typeTransformers.put(EntityDataSerializers.Type.STRING, new Transformer<String>(){

            @Override
            public String transform(Object other) {
                return (String)other;
            }

            @Override
            public net.minecraft.network.syncher.EntityDataSerializer<String> serializer() {
                return EntityDataSerializers.STRING;
            }
        });
        typeTransformers.put(EntityDataSerializers.Type.COMPONENT, new Transformer<Component>(){

            @Override
            public Component transform(Object other) {
                return (Component)ComponentSerializer.INSTANCE.toVanilla((net.kyori.adventure.text.Component)other);
            }

            @Override
            public net.minecraft.network.syncher.EntityDataSerializer<Component> serializer() {
                return EntityDataSerializers.COMPONENT;
            }
        });
        typeTransformers.put(EntityDataSerializers.Type.OPTIONAL_COMPONENT, new Transformer<Optional<Component>>(){

            @Override
            public Optional<Component> transform(Object other) {
                return ((Optional)other).map(ComponentSerializer.INSTANCE::toVanilla);
            }

            @Override
            public net.minecraft.network.syncher.EntityDataSerializer<Optional<Component>> serializer() {
                return EntityDataSerializers.OPTIONAL_COMPONENT;
            }
        });
        typeTransformers.put(EntityDataSerializers.Type.ITEM_STACK, new Transformer<ItemStack>(){

            @Override
            public ItemStack transform(Object other) {
                return ((WrappedItemStack)other).itemStack;
            }

            @Override
            public net.minecraft.network.syncher.EntityDataSerializer<ItemStack> serializer() {
                return EntityDataSerializers.ITEM_STACK;
            }
        });
        typeTransformers.put(EntityDataSerializers.Type.BOOLEAN, new Transformer<Boolean>(){

            @Override
            public Boolean transform(Object other) {
                return (Boolean)other;
            }

            @Override
            public net.minecraft.network.syncher.EntityDataSerializer<Boolean> serializer() {
                return EntityDataSerializers.BOOLEAN;
            }
        });
        typeTransformers.put(EntityDataSerializers.Type.PARTICLE, new Transformer<ParticleOptions>(){

            @Override
            public ParticleOptions transform(Object other) {
                ParticleData data = (ParticleData)other;
                FriendlyByteBufWrapper wrapper = (FriendlyByteBufWrapper)PacketTransformer.newByteBuf();
                ParticleTypes.write(data, wrapper);
                return (ParticleOptions)net.minecraft.core.particles.ParticleTypes.STREAM_CODEC.decode((Object)wrapper.buf());
            }

            @Override
            public net.minecraft.network.syncher.EntityDataSerializer<ParticleOptions> serializer() {
                return EntityDataSerializers.PARTICLE;
            }
        });
        typeTransformers.put(EntityDataSerializers.Type.ROTATIONS, new Transformer<Rotations>(){

            private static Rotations toRotations(EulerAngle eulerAngle) {
                return new Rotations((float)Math.toDegrees(eulerAngle.getX()), (float)Math.toDegrees(eulerAngle.getY()), (float)Math.toDegrees(eulerAngle.getZ()));
            }

            @Override
            public Rotations transform(Object other) {
                return 10.toRotations((EulerAngle)other);
            }

            @Override
            public net.minecraft.network.syncher.EntityDataSerializer<Rotations> serializer() {
                return EntityDataSerializers.ROTATIONS;
            }
        });
        typeTransformers.put(EntityDataSerializers.Type.POSE, new Transformer<net.minecraft.world.entity.Pose>(){
            private static final net.minecraft.world.entity.Pose[] poses = net.minecraft.world.entity.Pose.values();

            @Override
            public net.minecraft.world.entity.Pose transform(Object other) {
                return poses[((Pose)other).ordinal()];
            }

            @Override
            public net.minecraft.network.syncher.EntityDataSerializer<net.minecraft.world.entity.Pose> serializer() {
                return EntityDataSerializers.POSE;
            }
        });
        typeTransformers.put(EntityDataSerializers.Type.VECTOR3, new Transformer<Vector3fc>(){

            @Override
            public org.joml.Vector3f transform(Object other) {
                Vector3f vector3f = (Vector3f)other;
                return new org.joml.Vector3f(vector3f.x(), vector3f.y(), vector3f.z());
            }

            @Override
            public net.minecraft.network.syncher.EntityDataSerializer<Vector3fc> serializer() {
                return EntityDataSerializers.VECTOR3;
            }
        });
        typeTransformers.put(EntityDataSerializers.Type.QUATERNION, new Transformer<Quaternionfc>(){

            @Override
            public Quaternionf transform(Object other) {
                Quaternion quaternion = (Quaternion)other;
                return new Quaternionf(quaternion.x(), quaternion.y(), quaternion.z(), quaternion.w());
            }

            @Override
            public net.minecraft.network.syncher.EntityDataSerializer<Quaternionfc> serializer() {
                return EntityDataSerializers.QUATERNION;
            }
        });
        typeTransformers.put(EntityDataSerializers.Type.BLOCK_DATA, new Transformer<BlockState>(){

            @Override
            public BlockState transform(Object other) {
                BlockData data = (BlockData)other;
                return ((CraftBlockData)data).getState();
            }

            @Override
            public net.minecraft.network.syncher.EntityDataSerializer<BlockState> serializer() {
                return EntityDataSerializers.BLOCK_STATE;
            }
        });
    }

    public static interface Transformer<Z> {
        public Z transform(Object var1);

        public net.minecraft.network.syncher.EntityDataSerializer<Z> serializer();
    }
}

