/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axtrade.hooks.currency;

import com.artillexstudios.axtrade.hooks.currency.CurrencyHook;
import com.artillexstudios.axtrade.libs.axapi.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.coinsengine.api.CoinsEngineAPI;
import su.nightexpress.coinsengine.api.currency.Currency;

public class CoinsEngineHook
implements CurrencyHook {
    private Currency currency = null;
    private final Map<String, Object> settings;
    private final String internal;

    public CoinsEngineHook(Map<Object, Object> settings) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : settings.entrySet()) {
            map.put((String)entry.getKey(), entry.getValue());
        }
        this.settings = map;
        this.internal = (String)settings.get("currency-name");
    }

    @Override
    public void setup() {
        this.currency = CoinsEngineAPI.getCurrency((String)this.internal);
        if (this.currency == null) {
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF0000[AxTrade] CoinsEngine currency named &#DD0000" + this.internal + " &#FF0000not found! Change the currency-name or disable the hook to get rid of this warning!", new TagResolver[0]));
        }
    }

    @Override
    public String getName() {
        return "CoinsEngine-" + this.internal;
    }

    @Override
    public Map<String, Object> getSettings() {
        return this.settings;
    }

    @Override
    public boolean worksOffline() {
        return false;
    }

    @Override
    public boolean usesDouble() {
        return true;
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public double getBalance(@NotNull UUID player) {
        if (this.currency == null) {
            return 0.0;
        }
        return CoinsEngineAPI.getBalance((Player)Bukkit.getPlayer((UUID)player), (Currency)this.currency);
    }

    @Override
    public CompletableFuture<Boolean> giveBalance(@NotNull UUID player, double amount) {
        if (this.currency == null) {
            return CompletableFuture.completedFuture(false);
        }
        CoinsEngineAPI.addBalance((Player)Bukkit.getPlayer((UUID)player), (Currency)this.currency, (double)amount);
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public CompletableFuture<Boolean> takeBalance(@NotNull UUID player, double amount) {
        if (this.currency == null) {
            return CompletableFuture.completedFuture(false);
        }
        CoinsEngineAPI.removeBalance((Player)Bukkit.getPlayer((UUID)player), (Currency)this.currency, (double)amount);
        return CompletableFuture.completedFuture(true);
    }
}

