/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axtrade.libs.axapi.utils;

import com.artillexstudios.axtrade.libs.axapi.utils.featureflags.FeatureFlags;
import com.artillexstudios.axtrade.libs.axapi.utils.functions.ThrowingSupplier;
import com.artillexstudios.axtrade.libs.axapi.utils.logging.LogUtils;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class ExceptionUtils {
    public static <T> @Nullable T catching(Supplier<T> supplier) {
        return (T)ExceptionUtils.catching(supplier, (Exception exception) -> {
            if (((Boolean)FeatureFlags.LOG_EXCEPTION_UTILS_EXCEPTIONS.get()).booleanValue()) {
                LogUtils.error("ExceptionUtils caught exception!", exception);
            }
            return null;
        });
    }

    public static <T> @Nullable T catching(Supplier<T> supplier, Function<Exception, @Nullable T> function) {
        try {
            return supplier.get();
        }
        catch (Exception exception) {
            return function.apply(exception);
        }
    }

    public static <T> @Nullable T orElse(ThrowingSupplier<T> supplier, ThrowingSupplier<T> other, Function<Exception, @Nullable T> function) {
        try {
            return supplier.get();
        }
        catch (Exception exception) {
            try {
                return other.get();
            }
            catch (Exception otherException) {
                return function.apply(otherException);
            }
        }
    }

    public static void catching(Runnable runnable) {
        ExceptionUtils.catching(runnable, (Exception exception) -> {
            if (((Boolean)FeatureFlags.LOG_EXCEPTION_UTILS_EXCEPTIONS.get()).booleanValue()) {
                LogUtils.error("ExceptionUtils caught exception!", exception);
            }
        });
    }

    public static void catching(Runnable runnable, Consumer<Exception> consumer) {
        try {
            runnable.run();
        }
        catch (Exception exception) {
            consumer.accept(exception);
        }
    }
}

