/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axtrade.libs.axapi.nms.v1_21_R7_paper;

import com.artillexstudios.axtrade.libs.axapi.selection.BlockSetter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.jetbrains.annotations.NotNull;

public class BlockSetterImpl
implements BlockSetter {
    private static final ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();
    private final ServerLevel level;
    private final ArrayList<ChunkPos> chunks = new ArrayList();
    private LevelChunk chunk = null;

    public BlockSetterImpl(ServerLevel level) {
        this.level = level;
    }

    @Override
    public void setBlock(int x, int y, int z, BlockData data) {
        LevelChunk levelChunk;
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        if (this.chunk != null && chunkX == this.chunk.getPos().x && chunkZ == this.chunk.getPos().z) {
            levelChunk = this.chunk;
        } else {
            this.chunk = levelChunk = this.level.getChunk(chunkX, chunkZ);
            this.chunks.add(levelChunk.getPos());
        }
        BlockState state = ((CraftBlockData)data).getState();
        int sectionIndex = levelChunk.getSectionIndex(y);
        LevelChunkSection section = levelChunk.getSection(sectionIndex);
        int i = y;
        if (section.hasOnlyAir() && state.isAir()) {
            return;
        }
        int j = x & 0xF;
        int k = i & 0xF;
        int l = z & 0xF;
        section.setBlockState(j, k, l, state, false);
        this.updateHeightMap((ChunkAccess)levelChunk, j, y, l, state);
    }

    @Override
    public void finalise() {
        for (ChunkPos chunk : this.chunks) {
            LevelChunk levelChunk = this.level.getChunk(chunk.x, chunk.z);
            levelChunk.markUnsaved();
            this.sendUpdatePacket(levelChunk);
        }
        this.relight();
        this.chunks.clear();
    }

    private void updateHeightMap(ChunkAccess chunk, int x, int y, int z, BlockState blockState) {
        ((Heightmap)chunk.heightmaps.get(Heightmap.Types.MOTION_BLOCKING)).update(x, y, z, blockState);
        ((Heightmap)chunk.heightmaps.get(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES)).update(x, y, z, blockState);
        ((Heightmap)chunk.heightmaps.get(Heightmap.Types.OCEAN_FLOOR)).update(x, y, z, blockState);
        ((Heightmap)chunk.heightmaps.get(Heightmap.Types.WORLD_SURFACE)).update(x, y, z, blockState);
    }

    private void relight() {
        HashSet<ChunkPos> set = new HashSet<ChunkPos>(this.chunks);
        MinecraftServer.getServer().executeBlocking(() -> {
            ThreadedLevelLightEngine lightEngine = this.level.chunkSource.getLightEngine();
            lightEngine.starlight$serverRelightChunks((Collection)set, c -> {}, c -> {});
        });
    }

    private void sendUpdatePacket(@NotNull LevelChunk chunk) {
        ChunkHolder playerChunk = this.level.getChunkSource().chunkMap.getVisibleChunkIfPresent(chunk.getPos().longKey);
        if (playerChunk == null) {
            return;
        }
        List playersInRange = playerChunk.playerProvider.getPlayers(playerChunk.getPos(), false);
        executor.execute(() -> {
            ClientboundLevelChunkWithLightPacket lightPacket = new ClientboundLevelChunkWithLightPacket(chunk, this.level.getLightEngine(), null, null, false);
            int size = playersInRange.size();
            for (int i = 0; i < size; ++i) {
                ServerPlayer player = (ServerPlayer)playersInRange.get(i);
                player.connection.send((Packet)lightPacket);
            }
        });
    }
}

