/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axtrade.libs.axapi.nms.v1_21_R7.wrapper;

import com.artillexstudios.axtrade.libs.axapi.items.HashGenerator;
import com.artillexstudios.axtrade.libs.axapi.nms.v1_21_R7.packet.ChannelDuplexHandlerPacketListener;
import com.artillexstudios.axtrade.libs.axapi.nms.v1_21_R7.packet.PacketTransformer;
import com.artillexstudios.axtrade.libs.axapi.packet.wrapper.PacketWrapper;
import com.artillexstudios.axtrade.libs.axapi.reflection.FieldAccessor;
import com.artillexstudios.axtrade.libs.axapi.utils.ComponentSerializer;
import com.artillexstudios.axtrade.libs.axapi.utils.PlayerTextures;
import com.artillexstudios.axtrade.libs.axapi.utils.logging.LogUtils;
import com.google.common.cache.LoadingCache;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import java.util.Objects;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.inventory.ContainerSynchronizer;
import org.bukkit.attribute.Attribute;
import org.bukkit.craftbukkit.v1_21_R7.attribute.CraftAttribute;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPlayer;
import org.bukkit.entity.Player;

public final class ServerPlayerWrapper
implements com.artillexstudios.axtrade.libs.axapi.nms.wrapper.ServerPlayerWrapper {
    private static final FieldAccessor connectionAccessor = FieldAccessor.builder().withClass("net.minecraft.server.network.ServerCommonPacketListenerImpl").withField("e").build();
    private static final FieldAccessor channelAccessor = FieldAccessor.builder().withClass("net.minecraft.network.NetworkManager").withField("k").build();
    private static final FieldAccessor attributeAccessor = FieldAccessor.builder().withClass(AttributeMapBase.class).withField("d").build();
    private static final FieldAccessor containerSynchronizerAccessor = FieldAccessor.builder().withClass(EntityPlayer.class).withField("dE").build();
    private static final FieldAccessor cacheAccessor = FieldAccessor.builder().withClass("net.minecraft.server.level.EntityPlayer$1").withField("b").build();
    private final PacketTransformer transformer;
    private LoadingCache<Object, Integer> cache;
    private Player wrapped;
    private EntityPlayer serverPlayer;

    public ServerPlayerWrapper(Player player) {
        this.wrapped = player;
        this.transformer = new PacketTransformer(this);
    }

    public ServerPlayerWrapper(EntityPlayer player) {
        this.serverPlayer = player;
        this.transformer = new PacketTransformer(this);
    }

    @Override
    public void inject() {
        this.update();
        NetworkManager connection = connectionAccessor.get(this.serverPlayer.g, NetworkManager.class);
        Channel channel = channelAccessor.get(connection, Channel.class);
        if (!channel.pipeline().names().contains("packet_handler")) {
            return;
        }
        if (channel.pipeline().names().contains(AXAPI_HANDLER)) {
            return;
        }
        channel.eventLoop().submit(() -> channel.pipeline().addBefore("packet_handler", AXAPI_HANDLER, (ChannelHandler)new ChannelDuplexHandlerPacketListener(this)));
    }

    @Override
    public void uninject() {
        this.update();
        NetworkManager connection = connectionAccessor.get(this.serverPlayer.g, NetworkManager.class);
        Channel channel = channelAccessor.get(connection, Channel.class);
        channel.eventLoop().submit(() -> {
            if (channel.pipeline().get(AXAPI_HANDLER) != null) {
                channel.pipeline().remove(AXAPI_HANDLER);
            }
        });
    }

    @Override
    public void sendPacket(Object packet) {
        this.update();
        if (packet instanceof PacketWrapper) {
            PacketWrapper wrapper = (PacketWrapper)packet;
            this.serverPlayer.g.b((Packet)wrapper.cached());
            return;
        }
        if (!(packet instanceof Packet)) {
            LogUtils.warn("Failed to send unknown packet to player {}! Packet: {}", this.wrapped().getName(), packet);
            return;
        }
        Packet p = (Packet)packet;
        this.serverPlayer.g.b(p);
    }

    @Override
    public void message(Component message) {
        this.update();
        this.serverPlayer.g.b((Packet)new ClientboundSystemChatPacket((IChatBaseComponent)ComponentSerializer.INSTANCE.toVanilla(message), false));
    }

    @Override
    public double getBase(Attribute attribute) {
        this.update();
        AttributeMapBase map = this.serverPlayer.fw();
        AttributeProvider supplier = attributeAccessor.get(map, AttributeProvider.class);
        return supplier.b(CraftAttribute.bukkitToMinecraftHolder((Attribute)attribute));
    }

    @Override
    public PlayerTextures textures() {
        this.update();
        GameProfile profile = this.serverPlayer.gI();
        Optional property = profile.properties().get((Object)"textures").stream().findFirst();
        if (property.isEmpty()) {
            return new PlayerTextures(null, null);
        }
        Property value = (Property)property.get();
        return new PlayerTextures(value.value(), value.signature());
    }

    @Override
    public double getX() {
        this.update();
        return this.serverPlayer.dP();
    }

    @Override
    public double getZ() {
        this.update();
        return this.serverPlayer.dV();
    }

    @Override
    public HashGenerator hashGenerator() {
        this.update();
        return typed -> (Integer)this.cache.getUnchecked(typed);
    }

    @Override
    public Player wrapped() {
        Player wrapped = this.wrapped;
        if (wrapped == null) {
            this.wrapped = wrapped = this.serverPlayer.getBukkitEntity();
        }
        return wrapped;
    }

    @Override
    public void update(boolean force) {
        if (this.serverPlayer == null || force) {
            this.serverPlayer = ((CraftPlayer)this.wrapped).getHandle();
            ContainerSynchronizer synchronizer = containerSynchronizerAccessor.get(this.serverPlayer, ContainerSynchronizer.class);
            this.cache = (LoadingCache)cacheAccessor.getUnchecked(synchronizer);
        }
    }

    public EntityPlayer asMinecraft() {
        this.update();
        return this.serverPlayer;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ServerPlayerWrapper)) {
            return false;
        }
        ServerPlayerWrapper that = (ServerPlayerWrapper)o;
        this.update();
        that.update();
        if (Objects.equals(this.serverPlayer, that.serverPlayer)) {
            return true;
        }
        return this.wrapped().getUniqueId().equals(that.wrapped().getUniqueId());
    }

    public int hashCode() {
        this.update();
        return Objects.hashCode(this.serverPlayer);
    }
}

