/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axtrade.utils;

import com.artillexstudios.axtrade.AxTrade;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.ZonedDateTime;
import org.jetbrains.annotations.NotNull;

public class HistoryUtils {
    public static void writeToHistory(@NotNull String txt) {
        ZonedDateTime zdt = ZonedDateTime.now();
        File subdir = new File(AxTrade.getInstance().getDataFolder().getPath() + System.getProperty("file.separator") + "history");
        subdir.mkdirs();
        File file = new File(subdir.getPath() + "/" + zdt.getYear() + "-" + HistoryUtils.twoDigit(zdt.getMonthValue()) + "-" + HistoryUtils.twoDigit(zdt.getDayOfMonth()) + ".log");
        try (FileWriter fr = new FileWriter(file.getAbsoluteFile(), true);
             PrintWriter pr = new PrintWriter(fr);){
            pr.print("[" + HistoryUtils.twoDigit(zdt.getHour()) + ":" + HistoryUtils.twoDigit(zdt.getMinute()) + ":" + HistoryUtils.twoDigit(zdt.getSecond()) + "] ");
            pr.println(txt);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @NotNull
    private static String twoDigit(int i) {
        return i > 9 ? Integer.toString(i) : "0" + i;
    }
}

