/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axtrade.utils;

import com.artillexstudios.axtrade.AxTrade;
import com.artillexstudios.axtrade.libs.axapi.items.WrappedItemStack;
import com.artillexstudios.axtrade.libs.axapi.libs.boostedyaml.block.implementation.Section;
import com.artillexstudios.axtrade.utils.ItemMatcher;
import com.artillexstudios.axtrade.utils.ShulkerUtils;
import java.util.List;
import java.util.Map;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class BlacklistUtils {
    public static boolean isBlacklisted(@Nullable ItemStack it) {
        if (it == null || it.getType().isAir()) {
            return false;
        }
        if (BlacklistUtils.checkLegacy(it)) {
            return true;
        }
        try {
            List list = AxTrade.CONFIG.getMapList("blacklist-items");
            if (list == null || list.isEmpty()) {
                return false;
            }
            for (ItemStack stack : ShulkerUtils.getShulkerContents(it, true)) {
                if (stack == null || stack.getType().isAir()) continue;
                WrappedItemStack wrap = WrappedItemStack.wrap(stack);
                for (Map<String, Object> map : list) {
                    ItemMatcher matcher = new ItemMatcher(wrap, map);
                    boolean result = matcher.isMatching();
                    if (!result) continue;
                    return true;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    private static boolean checkLegacy(ItemStack it) {
        Section section = AxTrade.CONFIG.getSection("blacklisted-items");
        if (section == null) {
            return false;
        }
        for (String s : section.getRoutesAsStrings(false)) {
            if (AxTrade.CONFIG.getString("blacklisted-items." + s + ".material") != null) {
                if (!it.getType().toString().equalsIgnoreCase(AxTrade.CONFIG.getString("blacklisted-items." + s + ".material"))) continue;
                return true;
            }
            if (AxTrade.CONFIG.getString("blacklisted-items." + s + ".name-contains") == null || it.getItemMeta() == null || !it.getItemMeta().getDisplayName().contains(AxTrade.CONFIG.getString("blacklisted-items." + s + ".name-contains"))) continue;
            return true;
        }
        return false;
    }
}

