/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axtrade.safety;

import com.artillexstudios.axtrade.AxTrade;
import com.artillexstudios.axtrade.libs.axapi.executor.ExceptionReportingScheduledThreadPool;
import com.artillexstudios.axtrade.libs.axapi.utils.Version;
import com.artillexstudios.axtrade.libs.axapi.utils.http.Requests;
import com.artillexstudios.axtrade.safety.Notifier;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.bukkit.plugin.java.JavaPlugin;

public enum SafetyManager {
    TRADING,
    CURRENCY_SELECTOR;

    private static final JavaPlugin instance;
    private static final Gson gson;
    private static ScheduledExecutorService service;
    private static Notifier notifier;
    private static boolean safe;
    private boolean enabled = true;

    public void set(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean get() {
        return this.enabled;
    }

    public static boolean isSafe() {
        return safe;
    }

    private static void check() {
        String body;
        String str = "https://api.artillex-studios.com/safety/?plugin=%s&version=%s&mc=%s".formatted(instance.getName(), instance.getDescription().getVersion(), Version.getProtocolVersion());
        try {
            body = Requests.get(str, Map.of()).body();
        }
        catch (Exception ignored) {
            return;
        }
        JsonArray disabled = (JsonArray)gson.fromJson(body, JsonArray.class);
        for (SafetyManager value : SafetyManager.values()) {
            value.set(true);
        }
        safe = true;
        for (JsonElement jsonElement : disabled) {
            try {
                SafetyManager.valueOf(jsonElement.getAsString()).set(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            safe = false;
        }
        if (!safe) {
            notifier.sendAlert();
        }
    }

    public static void start() {
        if (!AxTrade.CONFIG.getBoolean("enable-safety", true)) {
            return;
        }
        if (service != null) {
            return;
        }
        notifier = new Notifier();
        service = new ExceptionReportingScheduledThreadPool(0, Thread.ofVirtual().factory());
        service.scheduleAtFixedRate(SafetyManager::check, 0L, 3L, TimeUnit.MINUTES);
    }

    public static void stop() {
        if (service == null) {
            return;
        }
        service.shutdownNow();
    }

    static {
        instance = AxTrade.getInstance();
        gson = new GsonBuilder().create();
        service = null;
        notifier = null;
        safe = true;
    }
}

