/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axtrade.libs.axapi.database;

import com.artillexstudios.axtrade.libs.axapi.config.annotation.AutoGeneratedComment;
import com.artillexstudios.axtrade.libs.axapi.config.annotation.Hidden;
import com.artillexstudios.axtrade.libs.axapi.config.annotation.PostProcess;
import com.artillexstudios.axtrade.libs.axapi.config.annotation.Serializable;
import com.artillexstudios.axtrade.libs.axapi.database.DatabaseType;
import com.artillexstudios.axtrade.libs.axapi.database.DatabaseTypes;
import com.artillexstudios.axtrade.libs.axapi.utils.logging.LogUtils;

@Serializable
public class DatabaseConfig {
    @AutoGeneratedComment(value="Can be the following: ")
    public DatabaseType type = DatabaseTypes.defaultType();
    public String address = "127.0.0.1";
    public int port = 3306;
    public String database = "admin";
    public String username = "admin";
    public String password = "admin";
    @Hidden
    public String url = null;
    public Pool pool = new Pool();
    private String tablePrefix;

    public String tablePrefix() {
        return this.tablePrefix;
    }

    public void tablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    @Serializable
    public static class Pool {
        public int maximumPoolSize = 10;
        public int minimumIdle = 10;
        public int maximumLifetime = 1800000;
        public int keepaliveTime = 0;
        public int connectionTimeout = 5000;

        @PostProcess
        public void postProcess() {
            if (this.maximumPoolSize < 1) {
                LogUtils.warn("Maximum database pool size is lower than 1! This is not supported! Defaulting to 1.", new Object[0]);
                this.maximumPoolSize = 1;
            }
        }
    }
}

