/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axtrade.currency;

import com.artillexstudios.axtrade.hooks.currency.CurrencyHook;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.bukkit.entity.Player;

public class CurrencyProcessor {
    private final Player player;
    private final Set<Map.Entry<CurrencyHook, Double>> currencies;
    private final Map<Map.Entry<CurrencyHook, Double>, Boolean> states = new HashMap<Map.Entry<CurrencyHook, Double>, Boolean>();

    public CurrencyProcessor(Player player, Set<Map.Entry<CurrencyHook, Double>> currencies) {
        this.player = player;
        this.currencies = currencies;
    }

    public CompletableFuture<Boolean> run() {
        CompletableFuture[] futures = new CompletableFuture[this.currencies.size()];
        int i = 0;
        for (Map.Entry<CurrencyHook, Double> entry : this.currencies) {
            futures[i] = entry.getKey().takeBalance(this.player.getUniqueId(), entry.getValue());
            ++i;
        }
        CompletionStage success = CompletableFuture.allOf(futures).thenApply(unused -> {
            int j;
            boolean[] actions = new boolean[futures.length];
            boolean anyErrors = false;
            for (j = 0; j < futures.length; ++j) {
                actions[j] = (Boolean)futures[j].join();
                if (actions[j]) continue;
                anyErrors = true;
            }
            j = 0;
            for (Map.Entry<CurrencyHook, Double> entry : this.currencies) {
                this.states.put(entry, actions[j]);
                ++j;
            }
            if (anyErrors) {
                this.reverse();
            }
            return !anyErrors;
        });
        return success;
    }

    public CompletableFuture<Boolean> reverse() {
        for (Map.Entry<Map.Entry<CurrencyHook, Double>, Boolean> entry : this.states.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            entry.getKey().getKey().giveBalance(this.player.getUniqueId(), entry.getKey().getValue());
        }
        return null;
    }
}

